#include "mbed.h"
#include "TextLCD.h"

// mbed -> EZ1
// -----------
// VOUT -> +5
// GND  -> GND
// p20  -> AN


TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7
AnalogIn ain(p15);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

int main() {
    float adc, volts, grams;
    DigitalIn writebutton(p17);
    DigitalIn closebutton(p18);

    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    
    int writeenable = 0;
    int closefile = 0;
    
    writebutton.mode(PullUp);
    closebutton.mode(PullUp);
    
    while (1){
        writeenable = writebutton.read();
        closefile = closebutton.read();
        
        lcd.locate(0,0);
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts

        lcd.printf("%8.3f volts\n", volts);
        
        if(closefile == 0){
            fclose(fp);
            break;  
        }
        
        if(writeenable == 0){
            lcd.cls();
            lcd.printf("Recording Voltage...\n\n");
            fprintf(fp, "%8.3f volts\n", volts);
            lcd.printf("Done!\n\n");
            wait(0.5);
            lcd.cls();
        }
        
        wait(0.05);                 // 20Hz update rate (once per 0.05 seconds)
    }
}


