#include "mbed.h"
#include "unilynx.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

int current_production_avg;
int current_production;
int today_production;
int total_production;

int main()
{
    /* setup terminal */
    pc.baud(115200);
    /* setup RS485 */
    rs485init();
    pc.printf("ULX Data logger init, build %s",__TIME__);

    while(1) 
    {
        /* read parameters of interest */
        total_production        = readParameter(RAW_MEAS_VALUES, ENERGY_PRODUCTION, ID_RAW_MEAS_VALUES);
        pc.printf("Production Total: %d [Wh]\n",total_production);
        today_production        = readParameter(RAW_MEAS_VALUES, ENERGY_PRODUCTION_TODAY, ID_RAW_MEAS_VALUES);
        pc.printf("Production Today: %d [Wh]\n",today_production);
        //current_production_avg  = readParameter(RAW_SMOOTH_VALUES, INSTANT_ENERGY, ID_RAW_SMOOTH_VALUES);
        current_production      = readParameter(RAW_MEAS_VALUES, INSTANT_ENERGY, ID_RAW_MEAS_VALUES);
        //pc.printf("Production Now: %04d [W] Avg.: %04d [W] \n",current_production,current_production_avg);
        pc.printf("Production Now: %04d [W] \n",current_production);
        
        /* print to console*/
/*        pc.printf("Production Total: %d [Wh]\n",total_production);
        pc.printf("Production Today: %d [Wh]\n",today_production);
        pc.printf("Production Now: %04d [W] \n",current_production);
*/
        wait(3);

    }
}
