// Hello World! for the TextLCD
 
#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "ipaddr.h"
#include "RPCVariable.h"

IpAddr ip(192,168,1,121);
IpAddr netmask(255,255,255,0);
IpAddr gateway(192,168,1,1);
IpAddr dns(192,168,1,1);

EthernetNetIf eth(ip,netmask,gateway,dns);  
HTTPServer svr;

DigitalOut led1(LED1);

InterruptIn geigerIn(p5);

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

unsigned int count = 0;
unsigned int prev_count = 0;
unsigned int i = 0;


class MyHandler : public HTTPRequestHandler
{
public:
  MyHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket);
  virtual ~MyHandler();

//protected:
  static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTCPSocket) { return new MyHandler(rootPath, path, pTCPSocket); } //if we ever could do static virtual functions, this would be one

  virtual void doGet();
  virtual void doPost();
  virtual void doHead();
  
  virtual void onReadable(); //Data has been read
  virtual void onWriteable(); //Data has been written & buf is free
  virtual void onClose(); //Connection is closing
};

MyHandler::MyHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)
{
}

MyHandler::~MyHandler()
{
}

void MyHandler::doGet()
{
  const char* resp = "Hello world !";
  char a[64];
  sprintf(a, "%d CPM.\n\0", ::prev_count);
  //setContentLen( strlen(resp) );
  setContentLen( strlen(a) );

  respHeaders()["Connection"] = "close";

  //writeData(resp, strlen(resp));
  writeData(a, strlen(a));

}

void MyHandler::doPost()
{

}

void MyHandler::doHead()
{

}

  
void MyHandler::onReadable() //Data has been read
{

}

void MyHandler::onWriteable() //Data has been written & buf is free
{
  close(); //Data written, we can close the connection
}

void MyHandler::onClose() //Connection is closing
{
  //Nothing to do
}


void radioactive()
{
  count = count + 1;
}

void count_minutes()
{
    lcd.locate(0, 0);
    lcd.printf("%04dCPM ", count); lcd.printf("%02dsec", i);
    lcd.locate(0, 1);
    lcd.printf("Prev. %04dCPM ", prev_count);
    
    i = i + 1;
      
    if(i > 59)
    {
      i = 0;
      prev_count = count;
      count = 0;
    }
}

int main() {

  // Count variables clear.
  count = 0;
  prev_count = 0;

  lcd.cls();
  lcd.locate(0, 0);

  geigerIn.fall(&radioactive);

  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    return -1;
  }
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.addHandler<MyHandler>("/geiger"); 

  svr.bind(80);

  Ticker tick;
  tick.attach(count_minutes, 1);   
  
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }

}