/*
    32dot*16dot LED display demo.
    moving 'mbed'
*/

#include "mbed.h"
#include "kp1632d.h"

//if uses push SW (speed UP ,speed DOWN)
#define PUSH_SW

//Serial pc(SERIAL_TX, SERIAL_RX);
Serial pc(USBTX, USBRX);

#ifdef TARGET_LPC1768
KP1632D disp(p5,p6,p7,p8,p9,p10); //defalut interrupt speed = 200uS
    #ifdef PUSH_SW
    DigitalIn SW1(p19,PullUp),SW2(p20,PullUp);
    #endif
#endif
#ifdef TARGET_KLXX
KP1632D disp(D7,D9,D10,D6,D5,D4); //defalut interrupt speed = 200uS
    #ifdef PUSH_SW
    DigitalIn SW1(D2,PullUp),SW2(D3,PullUp);
    #endif
#endif
#ifdef TARGET_STM
KP1632D disp(D7,D9,D10,D6,D5,D4); //defalut interrupt speed = 200uS
    #ifdef PUSH_SW
    DigitalIn SW1(D2,PullUp),SW2(D3,PullUp);
    #endif
#endif
#ifndef PUSH_SW
DigitalIn SW1(NC),SW2(NC);
#endif
//KP1632D disp(D7,D9,D10,D6,D5,D4,1000); //set interrupt speed = 1000uS
//KP1632D disp(D7,D9,D10,D6,D5); //if ENB=NC, interrupt speed=defalut
//KP1632D disp(D7,D9,D10,D6,D5,NC,1000); //if ENB=NC, interrupt speed set

int main() {
    Timer timer;
    uint8_t x[8],y[8];
    int8_t d_x[8],d_y[8];

    uint32_t cg_buf[7];
    uint32_t ptn;
    
    uint8_t i,j;
    uint16_t w=100;
    uint8_t point_x[7][32]={};
    uint8_t point_y[7][32]={};
    uint8_t pp=0;
    
    bool sw1a=false;
    bool sw2a=false;

    pc.printf("Start KP-1632D demo. \r\n");

    disp.printf("mbed");//moved string
    for(i=0;i<7;i++)cg_buf[i]=disp.pbuf[i].i32; //copy string to CG buffer
    disp.cls();
    disp.printf("Startdemo");
    for(i=0;i<7;i++){
        x[i]=i;
        y[i]=10-i;
        d_x[i]=1;
        d_y[i]=1;
    }
    wait_ms(1000);

    timer.start();
    while(1) {
        if(timer.read_ms()>w){//wait refresh time
            //frame calc.
            timer.reset();
            pp=(pp+1)&31;
            for(i=0;i<7;i++){
                x[i] += d_x[i];//move X direction
                y[i] += d_y[i];//move Y direction
                if(x[i]>=31)d_x[i]=-d_x[i];//bound left
                if(x[i]==0)d_x[i]=-d_x[i];//bound right
                if(y[i]>=15)d_y[i]=-d_y[i];//bound lower
                if(y[i]==0)d_y[i]=-d_y[i];//bound upper
                point_x[i][pp]=x[i];
                point_y[i][pp]=y[i];
            }
            for(i=0;i<16;i++)disp.abuf[i].i32=0;
            ptn=1;
            for(i=0;i<32;i++){
                for(j=0;j<7;j++){
                    if(cg_buf[j] & ptn)disp.abuf[point_y[j][(pp+i)&31]].i32 |= (1<<point_x[j][(pp+i)&31]);
                }
                ptn <<= 1;
            }
            disp.tranfer_sw=true;
        }
        if(SW1==0){
            if(sw1a==false){
                sw1a=true;
                w += (w/10);
                if(w>1000)w=1000;//max 1 second
            }
        } else sw1a=false;
        if(SW2==0){
            if(sw2a==false){
                sw2a=true;
                w -= (w/10);
                if(w<20)w=20; //t>10mS (t>sw scan time)
            }
        } else sw2a=false;
           
        wait_ms(10);//push sw scan time
    }
}
