/*
    32dot*16dot LED display demo.
    For FRDM-KL25Z.
    地震計デモ
        2014.05.25
*/

#include "mbed.h"
#include "kp1632d.h"

Serial pc(USBTX, USBRX);
DigitalIn SW1(D2,PullUp),SW2(D3,PullUp);
KP1632D disp(D7,D9,D10,D6,D5,D4); //defalut interrupt speed = 200uS
I2C i2c(PTE25,PTE24); //MMA8451Q

void writeByte(uint8_t devAddr, uint8_t regAddr, uint8_t data) {
    char buf[2];
    buf[0]=regAddr;
    buf[1]=data;
    i2c.write(devAddr<<1,buf,2,false);
}

void readBytes(uint8_t device,uint8_t address, uint8_t length, char *data) {
    char buf[2];

    buf[0]=address;
    i2c.write(device<<1,buf,1,true);
    i2c.read(device<<1,data,length,false);
}

int main() {
    uint8_t i,n,buf[2];
    int16_t y,y0=8;
    uint8_t gs=3;
//float speed,l;
    const uint16_t gain[12]={1,2,5,10,20,50,100,200,500,1000,2000,5000};
//    const float K=((9.8e3/2)*50e-3)/4096; // G=9.8m/s^2 s=50mS N=4096/G

    Timer timer;
    timer.start();
    writeByte(0x1d,0x2a,0x01);  //MMA8451Q syscon reg 1 ,set ACTIVE mode

    while(1){
        timer.reset();
        readBytes(0x1d,0x03,2,(char*)buf); //MMA8451Q read Y axis
        y=(buf[0] << 6) | (buf[1] >> 2); //16bit left adjust -> 14bit right adjust
        if (y > 8191) y -= 16383; //offset binary -> 2'

//speed=y*K;// speed=mm/s (50ms)
//l += speed*50e-3;//mm (50ms)

        y=y/gain[gs] + 8;//display gain
        if(y<0)y=0;
        if(y>15)y=15;

        for(i=0;i<16;i++){
            disp.abuf[i].i32 <<= 1;
        }
        disp.abuf[y].i32 |= 1;
        if(y>y0){
            n=(y-y0)>>1;
            for(i=1;i<=n;i++){
                disp.abuf[y0+i].i32 |= 2;
                disp.abuf[y-i].i32 |= 1;
            }
        } else {
            n=(y0-y)>>1;
            for(i=1;i<=n;i++){
                disp.abuf[y+i].i32 |= 1;
                disp.abuf[y0-i].i32 |= 2;
            }
        }
        y0=y;

        disp.tranfer_sw=true;
        while(timer.read_ms()<50);   //wait_ms(50);
    }
}
