#ifndef MBED_KP1632D_H
#define MBED_KP1632D_H

#include "mbed.h"

class KP1632D : public Stream {
public:

union _buf{
  uint32_t i32;
  uint16_t i16[2];
  uint8_t  i8[4];
};

typedef union _buf flame_buf;

    KP1632D(PinName BD7851_COM, PinName BD7851_CA, PinName BD7851_CB, PinName BD7851_CLK, PinName BD7851_LT, PinName BD7851_ENB=NC, uint16_t period=200);
    void pset_XY(uint8_t X , uint8_t Y);
    void preset_XY(uint8_t X , uint8_t Y);
    void posline_X(uint8_t X , uint8_t pos);
    void cls();
    void gotoxy(uint8_t x,uint8_t y);
    flame_buf pbuf[16];
    flame_buf abuf[16];
    bool tranfer_sw;
    
protected:
    DigitalOut _BD7851_COM, _BD7851_CA, _BD7851_CB, _BD7851_CLK, _BD7851_LT, _BD7851_ENB;
    Ticker _ticker;
    void disp_isr();
    virtual int _getc();
    virtual int _putc(int value);
    uint8_t xp,yp;
};
#endif
