#include "mbed.h"
#include "kp1632d.h"
#include "CG.h"

KP1632D::KP1632D(PinName BD7851_COM, PinName BD7851_CA, PinName BD7851_CB, PinName BD7851_CLK, PinName BD7851_LT, PinName BD7851_ENB, uint16_t period) :
    _BD7851_COM(BD7851_COM), _BD7851_CA(BD7851_CA), _BD7851_CB(BD7851_CB), _BD7851_CLK(BD7851_CLK), _BD7851_LT(BD7851_LT), _BD7851_ENB(BD7851_ENB) {

    tranfer_sw=false;
    _BD7851_ENB=1;
    for(uint8_t i=0;i<16;i++)pbuf[i].i32=0;
    _ticker.attach_us(this,&KP1632D::disp_isr, period);//defalut value (int=5KHz frame rate=300Hz)
    wait_us(200*3);
    _BD7851_ENB=0;
    xp=0;
    yp=0;
}

void KP1632D::disp_isr(){
    static uint8_t pos=0;
    static uint16_t ptn,ssr_A=0,ssr_B=0,ssr_COM=0;
    uint8_t i;
 
    if(pos==0)ptn=0x8000;
    ssr_A=pbuf[pos].i16[0]; ssr_B=pbuf[pos].i16[1]; ssr_COM=ptn;
    for(i=0;i<16;i++){
        _BD7851_CA=(ssr_A & 0x8000)==0x8000;
        _BD7851_CB=(ssr_B & 0x8000)==0x8000;
        _BD7851_COM=ssr_COM & 1;
        ssr_COM >>= 1;
        _BD7851_CLK=1;
        ssr_A <<= 1;
        _BD7851_CLK=0;
        ssr_B <<= 1;
    }
    _BD7851_LT=1;
    ptn >>= 1;
    _BD7851_LT=0;
    pos = (pos+1) & 15;
    if((pos==0) && (tranfer_sw)){
        tranfer_sw=false;
        memcpy(pbuf,abuf,sizeof(pbuf));//4byte 16line
    }
}

void KP1632D::pset_XY(uint8_t X , uint8_t Y){
  if((X>31)||(Y>15))return;
  pbuf[Y].i8[X>>3] |= 1<<(X & 7);
}

void KP1632D::preset_XY(uint8_t X , uint8_t Y){
  if((X>31)||(Y>15))return;
  pbuf[Y].i8[X>>3] &= ~(1<<(X & 7));
}

void KP1632D::posline_X(uint8_t X , uint8_t pos){
  uint8_t i;

  if((X>31)||(pos>15))return;
  for(i=0;i<16;i++){
    if(i<=pos)pset_XY(X,i); else preset_XY(X,i);
  }
}

void KP1632D::cls(){
    for(uint8_t i=0;i<16;i++)pbuf[i].i32=0;
    xp=0;
    yp=0;
}

void KP1632D::gotoxy(uint8_t x,uint8_t y){
    xp=x; if(xp>4)xp=4;
    yp=y; if(yp>1)yp=1;
}

int KP1632D::_putc(int value) {
    uint8_t c,i,y;
    
    if(value==13){
        xp=0;
        return value;
    }
    if(yp>1)yp=1;
    if(value==10){
        yp++;
        if(yp>1){
            for(i=0;i<8;i++){
                pbuf[i].i32=pbuf[i+8].i32;
                pbuf[i+8].i32=0;
            }
            yp=1;
        }
        return value;
    }

    if(xp>4){
        xp=0; yp++;
        if(yp>1){
            for(i=0;i<8;i++){
                pbuf[i].i32=pbuf[i+8].i32;
                pbuf[i+8].i32=0;
            }
            yp=1;
        }
    }
    if((value>=0x20)&&(value<0x80)){
        c=value-0x20;
        y=yp*8;
        for(i=0;i<8;i++){
            pbuf[y+i].i32 |= (uint32_t)CG5x7[c][i]<<(4-xp)*6;
        }
        xp++;
    }
    return value;
}

int KP1632D::_getc() {
    return -1;
}
