/**
 * @file main.c
 * @brief ILI9163/DL144128TF 128x128 TFT LCD Test code
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Jun Morita (iccraft)
 *
 * @copyright   Copyright (C) 2012 Simon Inns
 * @author Simon Inns <simon.inns@gmail.com>
 */

#include "mbed.h"
#include "ili9163lcd.h"

DigitalOut LED(LED1);

int main()
{
    uint8_t tm=10;
    uint8_t R=0,G=0,B=0;
    uint8_t RGB_state=0;
    
    lcdInitialise(LCD_ORIENTATION3);
    
    lcdClearDisplay(decodeRgbValue(0, 0, 0));
    
    lcdLine(0, 0, 127, 127, decodeRgbValue(31, 31, 31));
    lcdLine(0, 127, 127, 0, decodeRgbValue(31, 31, 31));
    lcdCircle(64, 64, 32, decodeRgbValue(31, 0, 0));
    lcdCircle(64, 64, 40, decodeRgbValue(0, 31, 0));
    lcdCircle(64, 64, 48, decodeRgbValue(0, 0, 31));
    
    lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(31, 31, 31));
    
    lcdPutS("The quick brown fox jumped over the lazy dog 0123456789", lcdTextX(0), lcdTextY(2), decodeRgbValue(0, 31, 31), decodeRgbValue(0, 0, 0));
    
    lcdFilledRectangle(0, 64, 127, 127, decodeRgbValue(0, 0, 0));
    lcdRectangle(0, 64, 127, 127, decodeRgbValue(31, 31, 31));
    
    // Run the LCD test
    uint8_t ballX = 64, ballY = 96;
    int8_t ballSpeed = 1;
    int8_t xDir = ballSpeed, yDir = ballSpeed;
    
    // Bouncy ball demo
    while(1)
    {
        // Delete the ball
        lcdFilledRectangle(ballX-2, ballY-1, ballX+2, ballY+1, decodeRgbValue(0, 0, 0));
        
        // Delete the bat
        lcdFilledRectangle(ballX-4, 121, ballX+4, 123, decodeRgbValue(0, 0, 0));
        
        // Move the ball
        ballX += xDir;
        ballY += yDir;
        
        // Range check
        if (ballX > 120) xDir = -ballSpeed;
        if (ballX < 7) xDir = ballSpeed;
        
        if (ballY > 120) yDir = -ballSpeed;
        if (ballY < 70) yDir = ballSpeed;
        
        // Plot the ball
        lcdFilledRectangle(ballX-2, ballY-1, ballX+2, ballY+1, decodeRgbValue(31, 31, 31));
        
        // Plot the bat
        lcdFilledRectangle(ballX-4, 121, ballX+4, 123, decodeRgbValue(31, 0, 31));
        
//        lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(31, 31, 31));
        lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(R, G, B));
        switch (RGB_state){
            case 0:
                if(++R >= 31)RGB_state++;
                break;
            case 1:
                if(--R == 0)RGB_state++;
                break;
            case 2:
                if(++G >= 31)RGB_state++;
                break;
            case 3:
                if(--G == 0)RGB_state++;
                break;
            case 4:
                if(++B >= 31)RGB_state++;
                break;
            case 5:
                if(--B == 0)RGB_state++;
                break;
            case 6:
                if(++R >= 31)RGB_state++;
                B = R;
                break;
            case 7:
                if(-- R== 0)RGB_state++;
                B = R;
                break;
            case 8:
                if(++R >= 31)RGB_state++;
                G = R;
                break;
            case 9:
                if(-- R== 0)RGB_state++;
                G = R;
                break;
            case 10:
                if(++G >= 31)RGB_state++;
                B = G;
                break;
            case 11:
                if(-- G== 0)RGB_state++;
                B = G;
                break;
            case 12:
                if(++R >= 31)RGB_state++;
                B = G = R;
                break;
            case 13:
                if(--R == 0)RGB_state = 0;
                B = G = R;
                break;
        }
        wait_ms(10);
        if(--tm==0){
            tm=10;
            LED = LED ^ 1;
        }
    }
}
