/**
 * @file font5x8.h
 * @brief 5x8 Font Data
 *
 * This font was created by Philippe Lucidarme and is available
 * from http://piclist.com/techref/datafile/charset/8x6.htm
 */

#ifndef __ASSET_FONT_5X8
#define __ASSET_FONT_5X8
#define __FONT __ASSET_FONT

// Note: This table is arranged according to ASCII codes 0 to 255
const uint8_t font5x8[][6] = {
{0x00,0x00,0x00,0x00,0x00,0x00},   //   0x00 0
{0x00,0x64,0x18,0x04,0x64,0x18},   //   0x01 1
{0x00,0x3c,0x40,0x40,0x20,0x7c},   //   0x02 2
{0x00,0x0c,0x30,0x40,0x30,0x0c},   //   0x03 3
{0x00,0x3c,0x40,0x30,0x40,0x3c},   //   0x04 4
{0x00,0x00,0x3e,0x1c,0x08,0x00},   //   0x05 5
{0x00,0x04,0x1e,0x1f,0x1e,0x04},   //   0x06 6
{0x00,0x10,0x3c,0x7c,0x3c,0x10},   //   0x07 7
{0x00,0x20,0x40,0x3e,0x01,0x02},   //   0x08 8
{0x00,0x22,0x14,0x08,0x14,0x22},   //   0x09 9
{0x00,0x00,0x38,0x28,0x38,0x00},   //   0x0a 10
{0x00,0x00,0x10,0x38,0x10,0x00},   //  0x0b 11
{0x00,0x00,0x00,0x10,0x00,0x00},   //  0x0c 12
{0x00,0x08,0x78,0x08,0x00,0x00},   //   0x0d 13
{0x00,0x00,0x15,0x15,0x0a,0x00},   //   0x0e 14
{0x00,0x7f,0x7f,0x09,0x09,0x01},   //   0x0f 15
{0x00,0x10,0x20,0x7f,0x01,0x01},   //   0x10 16
{0x00,0x04,0x04,0x00,0x01,0x1f},   //   0x11 17
{0x00,0x00,0x19,0x15,0x12,0x00},   //   0x12 18
{0x00,0x40,0x60,0x50,0x48,0x44},   //   0x13 19
{0x00,0x06,0x09,0x09,0x06,0x00},   //   0x14 20
{0x00,0x0f,0x02,0x01,0x01,0x00},   //   0x15 21
{0x00,0x00,0x01,0x1f,0x01,0x00},   //   0x16 22
{0x00,0x44,0x44,0x4a,0x4a,0x51},   //   0x17 23
{0x00,0x14,0x74,0x1c,0x17,0x14},   //   0x18 24
{0x00,0x51,0x4a,0x4a,0x44,0x44},   //   0x19 25
{0x00,0x00,0x00,0x04,0x04,0x04},   //   0x1a 26
{0x00,0x00,0x7c,0x54,0x54,0x44},   //   0x1b 27
{0x00,0x08,0x08,0x2a,0x1c,0x08},   //   0x1c 28
{0x00,0x7c,0x00,0x7c,0x44,0x7c},   //   0x1d 29
{0x00,0x04,0x02,0x7f,0x02,0x04},   //   0x1e 30
{0x00,0x10,0x20,0x7f,0x20,0x10},   //   0x1f 31
{0x00,0x00,0x00,0x00,0x00,0x00},   //   0x20 32
{0x00,0x00,0x00,0x6f,0x00,0x00},   // ! 0x21 33
{0x00,0x00,0x07,0x00,0x07,0x00},   // " 0x22 34
{0x00,0x14,0x7f,0x14,0x7f,0x14},   // # 0x23 35
{0x00,0x00,0x07,0x04,0x1e,0x00},   // $ 0x24 36
{0x00,0x23,0x13,0x08,0x64,0x62},   // % 0x25 37
{0x00,0x36,0x49,0x56,0x20,0x50},   // & 0x26 38
{0x00,0x00,0x00,0x07,0x00,0x00},   // ' 0x27 39
{0x00,0x00,0x1c,0x22,0x41,0x00},   // ( 0x28 40
{0x00,0x00,0x41,0x22,0x1c,0x00},   // ) 0x29 41
{0x00,0x14,0x08,0x3e,0x08,0x14},   // * 0x2a 42
{0x00,0x08,0x08,0x3e,0x08,0x08},   // + 0x2b 43
{0x00,0x00,0x50,0x30,0x00,0x00},   // , 0x2c 44
{0x00,0x08,0x08,0x08,0x08,0x08},   // - 0x2d 45
{0x00,0x00,0x60,0x60,0x00,0x00},   // . 0x2e 46
{0x00,0x20,0x10,0x08,0x04,0x02},   // / 0x2f 47
{0x00,0x3e,0x51,0x49,0x45,0x3e},   // 0 0x30 48
{0x00,0x00,0x42,0x7f,0x40,0x00},   // 1 0x31 49
{0x00,0x42,0x61,0x51,0x49,0x46},   // 2 0x32 50
{0x00,0x21,0x41,0x45,0x4b,0x31},   // 3 0x33 51
{0x00,0x18,0x14,0x12,0x7f,0x10},   // 4 0x34 52
{0x00,0x27,0x45,0x45,0x45,0x39},   // 5 0x35 53
{0x00,0x3c,0x4a,0x49,0x49,0x30},   // 6 0x36 54
{0x00,0x01,0x71,0x09,0x05,0x03},   // 7 0x37 55
{0x00,0x36,0x49,0x49,0x49,0x36},   // 8 0x38 56
{0x00,0x06,0x49,0x49,0x29,0x1e},   // 9 0x39 57
{0x00,0x00,0x36,0x36,0x00,0x00},   // : 0x3a 58
{0x00,0x00,0x56,0x36,0x00,0x00},   // ; 0x3b 59
{0x00,0x08,0x14,0x22,0x41,0x00},   // < 0x3c 60
{0x00,0x14,0x14,0x14,0x14,0x14},   // = 0x3d 61
{0x00,0x00,0x41,0x22,0x14,0x08},   // > 0x3e 62
{0x00,0x02,0x01,0x51,0x09,0x06},   // ? 0x3f 63
{0x00,0x3e,0x41,0x5d,0x49,0x4e},   // @ 0x40 64
{0x00,0x7e,0x09,0x09,0x09,0x7e},   // A 0x41 65
{0x00,0x7f,0x49,0x49,0x49,0x36},   // B 0x42 66
{0x00,0x3e,0x41,0x41,0x41,0x22},   // C 0x43 67
{0x00,0x7f,0x41,0x41,0x41,0x3e},   // D 0x44 68
{0x00,0x7f,0x49,0x49,0x49,0x41},   // E 0x45 69
{0x00,0x7f,0x09,0x09,0x09,0x01},   // F 0x46 70
{0x00,0x3e,0x41,0x49,0x49,0x7a},   // G 0x47 71
{0x00,0x7f,0x08,0x08,0x08,0x7f},   // H 0x48 72
{0x00,0x00,0x41,0x7f,0x41,0x00},   // I 0x49 73
{0x00,0x20,0x40,0x41,0x3f,0x01},   // J 0x4a 74
{0x00,0x7f,0x08,0x14,0x22,0x41},   // K 0x4b 75
{0x00,0x7f,0x40,0x40,0x40,0x40},   // L 0x4c 76
{0x00,0x7f,0x02,0x0c,0x02,0x7f},   // M 0x4d 77
{0x00,0x7f,0x04,0x08,0x10,0x7f},   // N 0x4e 78
{0x00,0x3e,0x41,0x41,0x41,0x3e},   // O 0x4f 79
{0x00,0x7f,0x09,0x09,0x09,0x06},   // P 0x50 80
{0x00,0x3e,0x41,0x51,0x21,0x5e},   // Q 0x51 81
{0x00,0x7f,0x09,0x19,0x29,0x46},   // R 0x52 82
{0x00,0x46,0x49,0x49,0x49,0x31},   // S 0x53 83
{0x00,0x01,0x01,0x7f,0x01,0x01},   // T 0x54 84
{0x00,0x3f,0x40,0x40,0x40,0x3f},   // U 0x55 85
{0x00,0x0f,0x30,0x40,0x30,0x0f},   // V 0x56 86
{0x00,0x3f,0x40,0x30,0x40,0x3f},   // W 0x57 87
{0x00,0x63,0x14,0x08,0x14,0x63},   // X 0x58 88
{0x00,0x07,0x08,0x70,0x08,0x07},   // Y 0x59 89
{0x00,0x61,0x51,0x49,0x45,0x43},   // Z 0x5a 90
{0x00,0x3c,0x4a,0x49,0x29,0x1e},   // [ 0x5b 91
{0x00,0x02,0x04,0x08,0x10,0x20},   // \ 0x5c 92
{0x00,0x00,0x41,0x7f,0x00,0x00},   // ] 0x5d 93
{0x00,0x04,0x02,0x01,0x02,0x04},   // ^ 0x5e 94
{0x00,0x40,0x40,0x40,0x40,0x40},   // _ 0x5f 95
{0x00,0x00,0x00,0x03,0x04,0x00},   // ` 0x60 96
{0x00,0x20,0x54,0x54,0x54,0x78},   // a 0x61 97
{0x00,0x7f,0x48,0x44,0x44,0x38},   // b 0x62 98
{0x00,0x38,0x44,0x44,0x44,0x20},   // c 0x63 99
{0x00,0x38,0x44,0x44,0x48,0x7f},   // d 0x64 100
{0x00,0x38,0x54,0x54,0x54,0x18},   // e 0x65 101
{0x00,0x08,0x7e,0x09,0x01,0x02},   // f 0x66 102
{0x00,0x0c,0x52,0x52,0x52,0x3e},   // g 0x67 103
{0x00,0x7f,0x08,0x04,0x04,0x78},   // h 0x68 104
{0x00,0x00,0x44,0x7d,0x40,0x00},   // i 0x69 105
{0x00,0x20,0x40,0x44,0x3d,0x00},   // j 0x6a 106
{0x00,0x00,0x7f,0x10,0x28,0x44},   // k 0x6b 107
{0x00,0x00,0x41,0x7f,0x40,0x00},   // l 0x6c 108
{0x00,0x7c,0x04,0x18,0x04,0x78},   // m 0x6d 109
{0x00,0x7c,0x08,0x04,0x04,0x78},   // n 0x6e 110
{0x00,0x38,0x44,0x44,0x44,0x38},   // o 0x6f 111
{0x00,0x7c,0x14,0x14,0x14,0x08},   // p 0x70 112
{0x00,0x08,0x14,0x14,0x18,0x7c},   // q 0x71 113
{0x00,0x7c,0x08,0x04,0x04,0x08},   // r 0x72 114
{0x00,0x48,0x54,0x54,0x54,0x20},   // s 0x73 115
{0x00,0x04,0x3f,0x44,0x40,0x20},   // t 0x74 116
{0x00,0x3c,0x40,0x40,0x20,0x7c},   // u 0x75 117
{0x00,0x1c,0x20,0x40,0x20,0x1c},   // v 0x76 118
{0x00,0x3c,0x40,0x30,0x40,0x3c},   // w 0x77 119
{0x00,0x44,0x28,0x10,0x28,0x44},   // x 0x78 120
{0x00,0x0c,0x50,0x50,0x50,0x3c},   // y 0x79 121
{0x00,0x44,0x64,0x54,0x4c,0x44},   // z 0x7a 122
{0x00,0x00,0x08,0x36,0x41,0x41},   // { 0x7b 123
{0x00,0x00,0x00,0x7f,0x00,0x00},   // | 0x7c 124
{0x00,0x41,0x41,0x36,0x08,0x00},   // } 0x7d 125
{0x00,0x04,0x02,0x04,0x08,0x04},   // ~ 0x7e 126
{0x00,0x7f,0x6b,0x6b,0x6b,0x7f},   //   0x7f 127
{0x00,0x00,0x7c,0x44,0x7c,0x00},   // ? 0x80 128
{0x00,0x00,0x08,0x7c,0x00,0x00},   // ? 0x81 129
{0x00,0x00,0x64,0x54,0x48,0x00},   // ? 0x82 130
{0x00,0x00,0x44,0x54,0x28,0x00},   // ? 0x83 131
{0x00,0x00,0x1c,0x10,0x78,0x00},   // ? 0x84 132
{0x00,0x00,0x5c,0x54,0x24,0x00},   // ? 0x85 133
{0x00,0x00,0x78,0x54,0x74,0x00},   // ? 0x86 134
{0x00,0x00,0x64,0x14,0x0c,0x00},   // ? 0x87 135
{0x00,0x00,0x7c,0x54,0x7c,0x00},   // ? 0x88 136
{0x00,0x00,0x5c,0x54,0x3c,0x00},   // ? 0x89 137
{0x00,0x78,0x24,0x26,0x25,0x78},   // ? 0x8a 138
{0x00,0x78,0x25,0x26,0x24,0x78},   // ? 0x8b 139
{0x00,0x70,0x2a,0x29,0x2a,0x70},   // ? 0x8c 140
{0x00,0x78,0x25,0x24,0x25,0x78},   // ? 0x8d 141
{0x00,0x20,0x54,0x56,0x55,0x78},   // } 0x8e 142
{0x00,0x20,0x55,0x56,0x54,0x78},   // ? 0x8f 143
{0x00,0x20,0x56,0x55,0x56,0x78},   // ? 0x90 144
{0x00,0x20,0x55,0x54,0x55,0x78},   // ? 0x91 145
{0x00,0x7c,0x54,0x56,0x55,0x44},   // ? 0x92 146
{0x00,0x7c,0x55,0x56,0x54,0x44},   // ? 0x93 147
{0x00,0x7c,0x56,0x55,0x56,0x44},   // ? 0x94 148
{0x00,0x7c,0x55,0x54,0x55,0x44},   // ? 0x95 149
{0x00,0x38,0x54,0x56,0x55,0x18},   // ? 0x96 150
{0x00,0x38,0x55,0x56,0x54,0x18},   // ? 0x97 151
{0x00,0x38,0x56,0x55,0x56,0x18},   // ? 0x98 152
{0x00,0x38,0x55,0x54,0x55,0x18},   // ? 0x99 153
{0x00,0x00,0x44,0x7e,0x45,0x00},   // ? 0x9a 154
{0x00,0x00,0x45,0x7e,0x44,0x00},   // ? 0x9b 155
{0x00,0x00,0x46,0x7d,0x46,0x00},   // ? 0x9c 156
{0x00,0x00,0x45,0x7c,0x45,0x00},   // ? 0x9d 157
{0x00,0x00,0x48,0x7a,0x41,0x00},   // ~ 0x9e 158
{0x00,0x00,0x49,0x7a,0x40,0x00},   // ? 0x9f 159
{0x00,0x00,0x4a,0x79,0x42,0x00},   //   0xa0 160
{0x00,0x00,0x49,0x78,0x41,0x00},   // ? 0xa1 161
{0x00,0x38,0x44,0x46,0x45,0x38},   // ? 0xa2 162
{0x00,0x38,0x45,0x46,0x44,0x38},   // ? 0xa3 163
{0x00,0x38,0x46,0x45,0x46,0x38},   // ? 0xa4 164
{0x00,0x38,0x45,0x44,0x45,0x38},   // ? 0xa5 165
{0x00,0x30,0x48,0x4a,0x49,0x30},   // ? 0xa6 166
{0x00,0x30,0x49,0x4a,0x48,0x30},   // ? 0xa7 167
{0x00,0x30,0x4a,0x49,0x4a,0x30},   // ? 0xa8 168
{0x00,0x30,0x49,0x48,0x49,0x30},   // ? 0xa9 169
{0x00,0x3c,0x40,0x42,0x41,0x3c},   // ? 0xaa 170
{0x00,0x3c,0x41,0x42,0x40,0x3c},   // ? 0xab 171
{0x00,0x3c,0x42,0x41,0x42,0x3c},   // ? 0xac 172
{0x00,0x3c,0x41,0x40,0x41,0x3c},   // ?  0xad 173
{0x00,0x3c,0x40,0x42,0x21,0x7c},   // ? 0xae 174
{0x00,0x3c,0x41,0x42,0x20,0x7c},   // ? 0xaf 175
{0x00,0x38,0x42,0x41,0x22,0x78},   // ? 0xb0 176
{0x00,0x3c,0x41,0x40,0x21,0x7c},   // ? 0xb1 177
{0x00,0x4e,0x51,0x71,0x11,0x0a},   // ? 0xb2 178
{0x00,0x58,0x64,0x64,0x24,0x10},   // ? 0xb3 179
{0x00,0x7c,0x0a,0x11,0x22,0x7d},   // ? 0xb4 180
{0x00,0x78,0x12,0x09,0x0a,0x71},   // ? 0xb5 181
{0x00,0x00,0x00,0x04,0x02,0x01},   // ? 0xb6 182
{0x00,0x01,0x02,0x04,0x00,0x00},   // ? 0xb7 183
{0x00,0x00,0x02,0x00,0x02,0x00},   // ? 0xb8 184
{0x00,0x30,0x48,0x45,0x40,0x20},   // ? 0xb9 185
{0x00,0x00,0x00,0x7b,0x00,0x00},   // ? 0xba 186
{0x00,0x38,0x44,0x44,0x38,0x44},   // ? 0xbb 187
{0x00,0x40,0x3e,0x49,0x49,0x36},   // ? 0xbc 188
{0x00,0x08,0x04,0x08,0x70,0x0c},   // ? 0xbd 189
{0x00,0x60,0x50,0x48,0x50,0x60},   // ? 0xbe 190
{0x00,0x20,0x52,0x55,0x59,0x30},   // ? 0xbf 191
{0x00,0x38,0x54,0x54,0x54,0x00},   // ? 0xc0 192
{0x00,0x00,0x00,0x7f,0x41,0x00},   // ? 0xc1 193
{0x00,0x40,0x22,0x14,0x18,0x60},   // ? 0xc2 194
{0x00,0x7c,0x20,0x20,0x1c,0x20},   // ? 0xc3 195
{0x00,0x44,0x3c,0x04,0x7c,0x44},   // ? 0xc4 196
{0x00,0x40,0x3c,0x12,0x12,0x0c},   // ? 0xc5 197
{0x00,0x41,0x63,0x55,0x49,0x41},   // ? 0xc6 198
{0x00,0x38,0x44,0x44,0x3c,0x04},   // ? 0xc7 199
{0x00,0x08,0x04,0x3c,0x44,0x24},   // ? 0xc8 200
{0x00,0x08,0x14,0x7f,0x14,0x08},   // ? 0xc9 201
{0x00,0x4e,0x71,0x01,0x71,0x4e},   // ? 0xca 202
{0x00,0x45,0x29,0x11,0x29,0x45},   // ? 0xcb 203
{0x00,0x0d,0x51,0x51,0x51,0x3d},   // ? 0xcc 204
{0x00,0x00,0x00,0x05,0x02,0x05},   // ? 0xcd 205
{0x00,0x40,0x00,0x40,0x00,0x40},   // ? 0xce 206
{0x00,0x00,0x08,0x1c,0x3e,0x00},   // ? 0xcf 207
{0x00,0x1c,0x1c,0x1c,0x00,0x00},   // ? 0xd0 208
{0x00,0x00,0x70,0x08,0x07,0x00},   // ? 0xd1 209
{0x00,0x00,0x08,0x08,0x08,0x00},   // ? 0xd2 210
{0x00,0x00,0x1d,0x15,0x17,0x00},   // ? 0xd3 211
{0x00,0x00,0x07,0x05,0x07,0x00},   // ? 0xd4 212
{0x00,0x00,0x11,0x15,0x0a,0x00},   // ? 0xd5 213
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xd6 214
{0x00,0x04,0x3c,0x41,0x20,0x00},   // ? 0xd7 215
{0x00,0x7c,0x16,0x15,0x16,0x08},   // ? 0xd8 216
{0x00,0x21,0x16,0x08,0x34,0x42},   // ? 0xd9 217
{0x00,0x7f,0x09,0x1d,0x01,0x03},   // ? 0xda 218
{0x00,0x38,0x54,0x54,0x14,0x08},   // ? 0xdb 219
{0x00,0x00,0x00,0x7c,0x40,0x40},   // ? 0xdc 220
{0x00,0x7f,0x0e,0x1c,0x38,0x7f},   // ? 0xdd 221
{0x00,0x41,0x22,0x5d,0x22,0x1c},   // ? 0xde 222
{0x00,0x1c,0x3e,0x1c,0x08,0x00},   // ? 0xdf 223
{0x00,0x7f,0x7f,0x7f,0x7f,0x7f},   // ? 0xe0 224
{0x00,0x77,0x7b,0x01,0x7b,0x77},   // ? 0xe1 225
{0x00,0x7f,0x43,0x75,0x43,0x7f},   // ? 0xe2 226
{0x00,0x7f,0x6f,0x55,0x43,0x7f},   // ? 0xe3 227
{0x00,0x40,0x40,0x40,0x40,0x40},   // ? 0xe4 228
{0x00,0x44,0x42,0x5f,0x42,0x44},   // ? 0xe5 229
{0x00,0x40,0x5e,0x45,0x5e,0x40},   // ? 0xe6 230
{0x00,0x40,0x48,0x55,0x5e,0x40},   // ? 0xe7 231
{0x00,0x00,0x04,0x08,0x10,0x20},   // ? 0xe8 232
{0x00,0x03,0x07,0x0e,0x1c,0x38},   // ? 0xe9 233
{0x00,0x01,0x03,0x07,0x0f,0x1f},   // ? 0xea 234
{0x00,0x7c,0x78,0x70,0x60,0x40},   // ? 0xeb 235
{0x00,0x08,0x08,0x1c,0x22,0x1c},   // ? 0xec 236
{0x00,0x00,0x1c,0x22,0x1c,0x00},   // ? 0xed 237
{0x00,0x02,0x00,0x08,0x00,0x20},   // ? 0xee 238
{0x00,0x04,0x3e,0x3f,0x3e,0x04},   // ? 0xef 239
{0x00,0x10,0x3e,0x7e,0x3e,0x10},   // ? 0xf0 240
{0x00,0x55,0x2a,0x55,0x2a,0x55},   // ? 0xf1 241
{0x00,0x24,0x2a,0x7f,0x2a,0x12},   // ? 0xf2 242
{0x00,0x04,0x1e,0x1f,0x1e,0x04},   // ? 0xf3 243
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf4 244
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf5 245
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf6 246
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf7 247
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf8 248
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xf9 249
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xfa 250
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xfb 251
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xfc 252
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xfd 253
{0x00,0x00,0x00,0x00,0x00,0x00},   // ? 0xfe 254
{0x00,0x00,0x00,0x00,0x00,0x00}    // ? 0xff 255
};

#endif
