#include "mbed.h"

DigitalOut BD7851_COM(P0_23); //32x16 LED display Y line shift data
DigitalOut BD7851_CA(P0_16);  //   :    X line shift data A
DigitalOut BD7851_CB(P1_22);  //   :    X line shift data B
DigitalOut BD7851_CLK(P1_15); //   :    shift clock
DigitalOut BD7851_LT(P1_13);  //   :    latch
AnalogIn G_X(P0_12);  //X axis sensor (Analog)
AnalogIn G_Y(P0_13);  //Y axis sensor (Analog)
AnalogIn G_Z(P0_14);  //Z axis sensor (Analog)
DigitalOut ROM_CS(P0_11);  //CG ROM SPI CS
DigitalOut ROM_CLK(P1_29); //CG ROM SPI clock
DigitalOut ROM_DI(P0_9);   //CG ROM SPI MOSI
DigitalIn ROM_DO(P0_8);    //CG ROM SPI MISO
DigitalOut LED_R(P0_20);   //check LED
DigitalOut LED_I(P0_21);   //check LED
DigitalIn ISP(P0_1,PullUp);  //Sensor zero adj button

Ticker ticker;
Timer timer;

union _buf{
  uint32_t i32;
  uint16_t i16[2];
  uint8_t  i8[4];
};

typedef union _buf flame_buf;

static flame_buf buf[16],bufa[16];
volatile bool copy_sw=false;

//Timer ISR
void disp(void){
    static uint8_t pos=0;
    static uint16_t ptn,ssr_A=0,ssr_B=0,ssr_COM=0;
    uint8_t i;
 
    if(pos==0)ptn=0x8000;
    ssr_A=buf[pos].i16[0]; ssr_B=buf[pos].i16[1]; ssr_COM=ptn;
    for(i=0;i<16;i++){
        BD7851_CA=(ssr_A & 0x8000)==0x8000;
        BD7851_CB=(ssr_B & 0x8000)==0x8000;
        BD7851_COM=ssr_COM & 1;
        ssr_COM >>= 1;
        BD7851_CLK=1;
        ssr_A <<= 1;
        BD7851_CLK=0;
        ssr_B <<= 1;
    }
    BD7851_LT=1;
    ptn >>= 1;
    BD7851_LT=0;
    pos = (pos+1) & 15;
    if((pos==0) && (copy_sw)){
        copy_sw=false;
        memcpy(buf,bufa,4*16);//4byte 16line
    }
}

const uint8_t MiniCG[17][8]={
    {0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00},
    {0x04,0x0c,0x04,0x04,0x04,0x04,0x0e,0x00},
    {0x0e,0x11,0x01,0x06,0x08,0x10,0x1f,0x00},
    {0x0e,0x11,0x01,0x06,0x01,0x11,0x0e,0x00},
    {0x02,0x12,0x12,0x12,0x1f,0x02,0x02,0x00},
    {0x1f,0x10,0x10,0x0e,0x01,0x01,0x1e,0x00},
    {0x0e,0x10,0x10,0x1e,0x11,0x11,0x0e,0x00},
    {0x1f,0x01,0x01,0x02,0x01,0x04,0x04,0x00},
    {0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00},
    {0x0e,0x11,0x11,0x0f,0x01,0x01,0x0e,0x00},
    {0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00},
    {0x1e,0x11,0x11,0x1e,0x11,0x11,0x1e,0x00},
    {0x0e,0x11,0x10,0x10,0x10,0x11,0x0e,0x00},
    {0x1e,0x11,0x11,0x11,0x11,0x11,0x1e,0x00},
    {0x1f,0x10,0x10,0x1e,0x10,0x10,0x1f,0x00},
    {0x1f,0x10,0x10,0x1e,0x10,0x10,0x10,0x00},
    {0,0,0,0,0,0,0,0}
};

static uint8_t xp=0,yp=0;

void put_c(uint8_t c){
    uint8_t i;

    for(i=0;i<8;i++){
      buf[i+(yp<<3)].i32=buf[i+(yp<<3)].i32 | (MiniCG[c][i])<<((4-xp)*6)+2;
    }
    if(++xp>4){
        xp=0;
        yp++;
        if(yp>1){
            yp=1;
            for(i=0;i<8;i++){
                buf[i].i32=buf[i+8].i32;
                buf[i+8].i32=0;
            }
        }
    }
}

void put_2H(uint8_t d){
    put_c(d >> 4);
    put_c(d & 15);
}
void put_4H(uint16_t dd){
    put_2H(dd >> 8);
    put_2H(dd & 255);
}

void ROM_ssr8(uint8_t ssr){
    uint8_t i;

    for(i=0;i<8;i++){
        if(ssr & 128)ROM_DI=1; else ROM_DI=0;
        ssr <<= 1;
        ROM_CLK=1;
//        wait_us(1);
        ROM_CLK=0;
    }
}

//read one charter (32bytes) SJIS code
void read_block_CG(uint16_t code,uint8_t *cgb){
    uint8_t i,j,ssr;
    unsigned char  c1, c2, MSB ,LSB;
    uint32_t address, seq;

    // SJIS to kuten code conversion
    c1 = (code>>8);
    c2 = (code & 0xFF);
    seq = (c1<=159 ? c1-129 : c1-193)*188 + (c2<=126 ? c2-64 : c2-65);
    MSB = seq / 94 + 1;
    LSB = seq % 94 + 1;
    address = 0;
        
    if(     MSB >=  1 && MSB <= 15 && LSB >= 1 && LSB <= 94)
        address =( (MSB -  1) * 94 + (LSB - 1))*32;
    else if(MSB >= 16 && MSB <= 47 && LSB >= 1 && LSB <= 94)
        address =( (MSB - 16) * 94 + (LSB - 1))*32 + 0x0AA40L;
    else if(MSB >= 48 && MSB <= 84 && LSB >= 1 && LSB <= 94)
        address = ((MSB - 48) * 94 + (LSB - 1))*32 + 0x21CDFL;
    else if(MSB == 85 && LSB >= 1 && LSB <= 94)
        address = ((MSB - 85) * 94 + (LSB - 1))*32 + 0x3C4A0L;
    else if(MSB >= 88 && MSB <= 89 && LSB >= 1 && LSB <= 94)
        address = ((MSB - 88) * 94 + (LSB - 1))*32 + 0x3D060L;

    ROM_CS=0;
    ROM_CLK=0;
    ROM_ssr8(0x03);//read inst.
    ROM_ssr8((address >> 16) & 0xff);//read address A23..A16
    ROM_ssr8((address >> 8) & 0xff);//read address A15..A8
    ROM_ssr8(address & 0xff);//read address A7..A0

    for(j=0;j<32;j++){
        ssr=0;
        for(i=0;i<8;i++){
            ssr <<= 1;
            ROM_CLK=1;
            if(ROM_DO != 0)ssr |= 1;
            ROM_CLK=0;
        }
        *cgb++=ssr;
    }
    ROM_CS=1;
}

void put_cgp(uint16_t code,uint16_t *pbuf){
    uint8_t i,j,k[32];
    uint16_t tmp;

    read_block_CG(code,k);//get CG (32 bytes)
    
    for(i=0;i<16;i++)pbuf[i]=0;

    for(i=0;i<8;i++){
        for(j=0;j<8;j++){
            pbuf[j] <<= 1;
            pbuf[j+8] <<= 1;

            tmp=0;
            if(k[i+0] & 1) tmp = 0x100;
            if(k[i+8] & 1) tmp |= 1;
            pbuf[j] |= tmp;

            tmp=0;
            if(k[i+16] & 1) tmp = 0x100;
            if(k[i+24] & 1) tmp |= 1;
            pbuf[j+8] |= tmp;

            k[i+0] >>= 1;
            k[i+8] >>= 1;
            k[i+16] >>= 1;
            k[i+24] >>= 1;
        }
    }
}

const uint16_t  demo_str[][17]={
    {0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140},
    {0x8140,0x828D,0x8282,0x8285,0x8284,0x834E,0x8389,0x8345,0x8368,0x82CD,0x95D6,0x9798,0x82C5,0x82B7,0x8142,0x8140,0x8140},
    {0x8140,0x8352,0x8393,0x8370,0x8343,0x8389,0x82CC,0x8343,0x8393,0x8358,0x8367,0x815B,0x838B,0x82C6,0x82A9,0x8141,0x8140},
    {0x8140,0x8AC2,0x8BAB,0x90DD,0x92E8,0x82C6,0x82A9,0x8141,0x8E67,0x82A2,0x8E6E,0x82DF,0x82DC,0x82C5,0x82C9,0x954B,0x8140},
    {0x8140,0x9776,0x82C8,0x8DEC,0x8BC6,0x82CD,0x9573,0x9776,0x82C5,0x82B7,0x8142,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140},
    {0x8140,0x8352,0x8393,0x8370,0x8343,0x838B,0x82AA,0x8F49,0x82ED,0x82EA,0x82CE,0x8141,0x8274,0x8272,0x8261,0x8381,0x8140},
    {0x8140,0x8382,0x838A,0x82C9,0x836F,0x8343,0x8369,0x838A,0x82F0,0x935D,0x9197,0x82B7,0x82E9,0x82BE,0x82AF,0x8142,0x8140},
    {0x8140,0x8F91,0x82AB,0x8D9E,0x82DD,0x9180,0x8DEC,0x82F0,0x82B5,0x82C4,0x82A2,0x82E9,0x8AB4,0x8A6F,0x82B7,0x82E7,0x8140},
    {0x8140,0x82A0,0x82E8,0x82DC,0x82B9,0x82F1,0x8142,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140},
    {0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140,0x8140}
};
//messeage size
#define  X_MAX ((17-2)*16-1)
#define  Y_MAX ((10-3)*16)

int main() {
    uint8_t i,j,k,xp,yp;
    uint16_t wbuf[3][4][16];
    uint16_t gx,gy;
    int16_t x=0,y=0;
    int32_t dx=1,dy=1;
    uint8_t tmx=1,tmy=1;
    int16_t tmxv=1,tmyv=1;
    uint8_t ofx,ofy;
    uint64_t cl;
    uint16_t AD_offset_X=32768,AD_offset_Y=32768;
      
    ROM_CS=1;
    ticker.attach_us(&disp, 200);//int=5KHz frame rate=300Hz

    for(k=0;k<3;k++){
        for(j=0;j<4;j++){
            for(i=0;i<16;i++){
                wbuf[k][j][i]=0;
            }
        }
    }
/*
    for(i=0;i<4;i++)put_2H(moji[i]);
    while(1);
*/
    
    timer.start();
    while(1){
        xp=(x+0)>>4; yp=(y+16)>>4;
        ofx=x & 15; ofy=y & 15;
        put_cgp(demo_str[yp][xp],wbuf[1][1]);//1'st
        put_cgp(demo_str[yp][xp+1],wbuf[1][2]);//2'nd
        put_cgp(demo_str[yp][xp+2],wbuf[1][3]);//right
        put_cgp(demo_str[yp+1][xp],wbuf[2][1]);//botom 1'st
        put_cgp(demo_str[yp+1][xp+1],wbuf[2][2]);//botom 2'nd
        put_cgp(demo_str[yp+1][xp+2],wbuf[2][3]);//botom right
        if(copy_sw==false){
            for(j=0;j<16;j++){
                i=j+ofy;
                cl=((uint64_t)wbuf[(i>>4)+1][1][i & 15]<<32)|((uint64_t)wbuf[(i>>4)+1][2][i & 15]<<16)|(uint64_t)wbuf[(i>>4)+1][3][i & 15];
                cl >>= (16-ofx);
                bufa[j].i32=cl;
            }
            copy_sw=true;//
        }
        if(timer.read_ms()>3){
            timer.reset();

            gx=G_X.read_u16();
            if(ISP==0)AD_offset_X=gx;
            dx=dx+(gx-AD_offset_X)/50;
            if(dx>999)dx=999;
            if(dx<-999)dx=-999;
            dx=dx*9000/10000;
            if(dx)dx--;
            if(dx<0)dx++;

            gy=G_Y.read_u16();
            if(ISP==0)AD_offset_Y=gy;
            dy=dy-(gy-AD_offset_Y)/50;
            if(dy>999)dy=999;
            if(dy<-999)dy=-999;
            dy=dy*9000/10000;
            if(dy)dy--;
            if(dy<0)dy++;
//put_4H(dx);
//put_c(16);//blank
            if(dx != 0){
                tmxv=1000/dx;
                if(tmxv<0)tmxv = -tmxv;
                if(tmxv>100)tmxv=100;
                if(tmx>tmxv)tmx=tmxv;
                if(--tmx==0){
                    tmx=tmxv;
                    LED_I = LED_I ^ 1;
                    if(dx>0){
                        x=x+1;
                        if(x>X_MAX){
                            x=X_MAX;
                        }
                    }
                    if(dx<0){
                        x=x-1;
                        if(x<0){
                            x=0;
                        }
                    }
                }
            } else {
                LED_I=0;
            }
            if(dy != 0){
                tmyv=1000/dy;
                if(tmyv<0)tmyv = -tmyv;
                if(tmyv>100)tmyv=100;
                if(tmy>tmyv)tmy=tmyv;
                if(--tmy==0){
                    LED_R=LED_R ^ 1;
                    tmy=tmyv;
                    if(dy>0){
                        y=y+1;
                        if(y>Y_MAX){
                            y=Y_MAX;
                        }
                    }
                    if(dy<0){
                        y=y-1;
                        if(y<0){
                            y=0;
                        }
                    }
                }
            } else {
                LED_R=0;
            }
        }
    }
}
