//**********************
// Hygrometer and Thermometer for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AM2321.h"
#include "TextLCD.h"

//#pragma O0
//#pragma O1
//#pragma O2    // default
//#pragma O3
//#pragma Otime
//#pragma Ospace


#if defined(TARGET_LPC1768)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
DigitalOut led1(P0_20);
DigitalOut led2(P0_21);
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
DigitalOut led1(D13);
I2C i2c(D14,D15);
#endif

AM2321 am2321(i2c);
TextLCD lcd(p21, p22, p23, p24, p25, p26); // rs, e, d4-d7

int main() {
    
    char msg[10];
    int h;
    int t;
      
    while(1) {

        h = am2321.humidity();
        sprintf(msg,"%4.1f%%",h/10.0);
        lcd.locate(0,0);
        lcd.printf(msg);

        t = am2321.temperature();
        sprintf(msg,"%4.1fC",t/10.0);
        lcd.locate(0,1);
        lcd.printf(msg);

        wait(1);
    }

}