#include "mbed.h"
#include "TextLCD.h"

TextLCD mylcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

volatile int n;
int Raw_data[52];

DigitalOut REQUEST(p20);
DigitalIn DATA(p9);
InterruptIn CLOCK(p17);

void trigger() {                    //interrupt  when CLOCK falled 
    Raw_data[n] = DATA.read();
    n++;
}


int main() {
    int Y;              
    int Measured_Data[6];
    int Decimal_point;
    double temp_data , Indicate;

 while(1){
    wait(0.03);
    n=0;

    REQUEST.write(1);
    CLOCK.fall(&trigger);

    while(1){
        if(n>52) break;         //number of data 
    }

    CLOCK.fall(NULL);
    REQUEST.write(0);

    Y=20;
    for(int i=0;i<=5;i++){          //Raw_data[20]-[43] is Measured_Data
        Measured_Data[i] =  Raw_data[Y+3]*pow(2.0,3) + Raw_data[Y+2]*pow(2.0,2) + Raw_data[Y+1]*pow(2.0,1) + Raw_data[Y];
        Y=Y+4;
    }

    Decimal_point =  Raw_data[Y+3]*pow(2.0,3)+ Raw_data[Y+2]*pow(2.0,2) +Raw_data[Y+1]*pow(2.0,1)+ Raw_data[Y];     ///Raw_data[44]-[47] is Decimal_point
   
    temp_data  = Measured_Data[0]*100000 + Measured_Data[1]*10000 + Measured_Data[2]*1000 + Measured_Data[3]*100 + Measured_Data[4]*10 + Measured_Data[5];
 
    if (Raw_data[19]==1)                //19 is Sign. 0 is '+'  ,  1 is '-'
        temp_data  = -1* temp_data;

    Indicate = temp_data /pow(10.0,Decimal_point);

    mylcd.cls();
    mylcd.printf("%7.2f", Indicate);
   
    if(Raw_data[48]==0)
        mylcd.printf("mm");
    else
        mylcd.printf("inch");
 }
}
