/**********************************
check: OK, ublox 5T
**********************************/
#include "mbed.h"
#include "TinyGPS.h"
#include "TimerExtended.h"

TinyGPS gpsr;

// serial
Serial serial_gps(p9, p10);        // tx, rx
Serial serial_pc(USBTX, USBRX);    // tx, rx

Timer timer;
TimerExtended timer2;
TimerExtended timer3;

void setup()
{
    timer.start();
    timer2.start();
    
    serial_gps.baud(9600);
    serial_pc.baud(115200);  
    
    serial_pc.printf("hello\n");
    wait(3.0);  
    
    timer3.start();
}

void loop()
{
    if(serial_gps.readable())
    {
        //serial_pc.printf("hoge\n");
        char c = serial_gps.getc();
        //serial_pc.putc(c);
        bool gps_avairable = gpsr.encode(c);
        if(gps_avairable)
        {
            //serial_pc.printf("fuga\n");
            double lat, lon;
            unsigned long age;
            (void)gpsr.f_get_position(&lat, &lon, &age);
            
            int year;
            byte month, day, hour, minute, second;
            (void)gpsr.crack_datetime(&year, &month, &day, &hour, &minute, &second);
            
            double t = (double)timer.read_ms() / 1000.0;
            serial_pc.printf("%f, ", t);
            double t2 = (double)timer2.read_ms() / 1000.0;
            serial_pc.printf("%f, ", t2);
            double t3 = (double)timer3.read_ms() / 1000.0;
            serial_pc.printf("%f, ", t3);
            serial_pc.printf("%d-%02d-%02d %02d:%02d:%02d, ", year, month, day, hour, minute, second);
            serial_pc.printf("%f, %f\n", lat, lon);
        }
    }
}

int main() {
    setup();
    
    while(1) 
    {   
        loop();
    }
}
