/***************************************
TimerExtended
Purpose: you can use timer untill 24 days in milli seconds.
Author: Katsuhiro Morishita @2014
License: apache license 2, or MIT, which you like
****************************************/
#include "mbed.h"


class TimerExtended
{
private:
    Timer _t;
    Ticker _tk;
    long milli_second;
    
    void update()
    {
        if(this->milli_second < 2147483645)
            this->milli_second += this->_t.read_ms();
        this->_t.reset();
    }
public:
    TimerExtended()
    {
        this->milli_second = 0l;
    }
    
    // start timer
    void start()
    {
        this->_tk.attach(this, &TimerExtended::update, 2000.0);  // 2000.0 should be lower then max value of Timer obj.
        this->_t.start();
    }
    
    // like Arduino lib.
    long millis()
    {
        (void)this->update();
        return this->milli_second;
    }
    
    // return time [s] in double
    double read()
    {
        return (double)this->millis() / 1000.0;
    }
    
    // return time [ms]
    long read_ms()
    {
        return this->millis();
    }
    
};