#include "mbed.h"
#include "TFC.h"

#include "common.h"
#include "Spices.h"


void TFC_TickerUpdate()
{
    int i;
 
    for(i=0; i<NUM_TFC_TICKERS; i++)
     {
        if(TFC_Ticker[i]<0xFFFFFFFF) 
        {
            TFC_Ticker[i]++;
        }
    }
}

void DemoProgram()
{
  uint32_t i,j,t = 0;
 // float ReadPot0, ReadPot1;

      //Labview Application
      //note that there are some issues 
      if(TFC_Ticker[0]>1000 && TFC_LineScanImageReady>0) // every 2s ...
          {
           TFC_Ticker[0] = 0;
           TFC_LineScanImageReady=0; // must reset to 0 after detecting non-zero
          
              if(t==0)
                  t=4;
              else
                  t--;
              
               TFC_SetBatteryLED_Level(t);
              
               for(i=0;i<8;i++) // print one line worth of data (128) from Camera 0
               {
                  for(j=0;j<16;j++)
                  {
                       
                       TERMINAL_PRINTF("0x%X",TFC_LineScanImage0[(i*16)+j]);
                      
                       if((i==7) && (j==15))  // when last data reached put in line return
                           TERMINAL_PRINTF("\r\n",TFC_LineScanImage0[(i*16)+j]);
                       else
                           TERMINAL_PRINTF(",",TFC_LineScanImage0[(i*16)+j]);
                      
                  }
                  wait_ms(10);
               }                 
}}

 
int main()
{
    // TERMINAL TYPE  
    PC.baud(115200); // works with Excel and TeraTerm 
    //PC.baud(9600); // works with USB Serial Monitor Lite: https://play.google.com/store/apps/details?id=jp.ksksue.app.terminal; doesn't work > 9600
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000); // update ticker array every 2mS (2000 uS)
   
    TFC_Init();
    
    for(;;)
    {      
        //TFC_Task must be called in your main loop.  This keeps certain processing happy (I.E. Serial port queue check)
        //   TFC_Task();


        // If DIP switch 1 is high, then run MCP, else Demo program
        if(TFC_GetDIP_Switch()&0x01)
          // Run MCP
          MasterControlProgram();
        else      
          // Run Demo Program
          DemoProgram();
 
    } // end of infinite for loop
    
 
}
 
