 #include "stdio.h"
 #include "stdlib.h"
 #include "math.h"
 #include "mbed.h"
 #include "ST7735_TFT.h"
 #include "string"
 #include "Arial12x12.h"

 #define SCREEN_WIDTH 160
 #define SCREEN_HEIGHT 128
 
 // Antendo M018C7735SPI TFT-LCD
 // with mbed LPC1768
 // the TFT is connected to SPI pin 5-7, CS is p8, RS is p11, reset is p15 
 // ST7735_TFT TFT(p5, p6, p7, p8, p11, p15, "TFT"); // mosi, miso, sclk, cs, rs, reset
 // with FRDM-KL25Z
 ST7735_TFT TFT(PTD2, PTD3, PTD1, PTC11, PTC12, PTC13, "TFT"); // PTA13, PTD5, PTD0, "TFT"); 
 /*
 ST7735_TFT(                    // for FRDM-KL25
    PinName mosi = SDA, // p5 9    // PTD2
    PinName miso = NC,  // p6(NC)      // PTD3
    PinName sclk = SCK, // p7, 10   // PTD1
    PinName cs = CS, // p8 15      // PTA13
    PinName rs = A0, // 8       // PTD5
    PinName reset = RESET // 17 // PTD0
);
*/

#define USE_LED 0

#if USE_LED
DigitalOut myled1(LED1);
#endif
 
Serial pc(USBTX, USBRX); // tx, rx
Timer t;

extern const unsigned char p1[];  // the mbed logo
 
int main() {
    
    unsigned int centerx, centery;
    int i, j; // tempx, tempy;  
    // init();
    TFT.set_orientation(1);
    centerx = TFT.width() >> 1;
    centery = TFT.height() >> 1; 
    TFT.claim(stdout);      // send stdout to the TFT display 
    //TFT.claim(stderr);      // send stderr to the TFT display

 while (1) {   
    fprintf(stderr, "START\r\n");
     
    TFT.background(White);    // set background to black
    TFT.foreground(Black);    // set chars to white
    
    TFT.cls();
    // break;
    // TFT.set_font((unsigned char*) Arial24x23);  // select the font
    TFT.set_font((unsigned char*) Arial12x12); 

    TFT.Bitmap(centerx-64,centery-24,128,47, (unsigned char*)p1);
    // TFT.rect(0, 0, 4, 127, Blue);
    
    for (i = 0; i < SCREEN_HEIGHT; i+=8) 
        TFT.line(0, i, SCREEN_WIDTH - 1, i, Red);
    for (j = 0; j < SCREEN_WIDTH; j+=8)
        TFT.line(j, 0, j, SCREEN_HEIGHT - 1, Blue);
        
    for (i = 0; i < SCREEN_HEIGHT; i++) 
        // for (j = 0; j < SCREEN_WIDTH; j++)
        TFT.pixel(i, i, Green);
    
    // TFT.locate(16,10);
    // TFT.set_font((unsigned char*) Arial2x12);  // select the font
    // printf("Time %f s\n", t.read());

    // wait(0.5);
    TFT.Bitmap(centerx-64,centery-24,128,47,(unsigned char*)p1);
    // TFT.locate(76,100);
    // fprintf(stdout, "ss_ABC");
    TFT.locate(24,100);
    fprintf(stdout, "@n24bass_ABC");
    // TFT.locate(76,100);
    // fprintf(stdout, "ss_ABC");
    // fprintf(stderr, "END\r\n");
    break;
}
#if USE_LED 
    while (1) {
        myled1 = 1;
        wait(0.5);
        myled1 = 0;
        wait(0.5);
    }
#endif
    while (1)
        wait(1);
  }