/*** Hello 7seg

    7seg module  logical_name LPC1114 PIN
    SEG-A(11)    dp1                1
    SEG-B(7)     dp2                2
    SEG-C(4)     dp4                4
    SEG-D(2)     dp26 (was dp5)     26
    SEG-E(1)     dp6                6
    SEG-F(10)    dp9                9
    SEG-G(5)     dp10               10
    SEG-DP(3)    dp11               11

    DIG-1(12)    dp13               13
    DIG-2 (9)    dp17               17
    DIG-3 (8)    dp18               18
    DIG-4 (6)    dp25               25

 */

#include "mbed.h"
#include "Sseg.h"

Sseg mySseg = Sseg(dp1, dp2, dp4, dp26, dp6, dp9, dp10, dp11, dp13, dp17, dp18, dp25);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

char hello[] = {
  0x00,
  0x00,
  0x00,
  0x00,
  0x6e, // 0b01101110, // H
  0x9e, // 0b10011110, // E
  0x1c, // 0b00011100, // L
  0x1c, // 0b00011100, // L
  0x3a, // 0b00111010, // o
  0x00, // 0b00000000, // 
  NUM_PAT_7,  // 7
  0xb6, // 0b10110110, // S
  NUM_PAT_E,  // E
  0xf6, // 0b11110110, // G
  0x01, // 0b00000001 // .
};

#define OVERWRAP(a, x) (((x) < sizeof(a)) ? (a[(x)]) : a[((x) - sizeof(a))])

int main() {
    mySseg.setKcommon();
    mySseg.begin();

    // mySseg.writeRawData(NUM_PAT_0, NUM_PAT_1, NUM_PAT_2, NUM_PAT_3);
    // mySseg.writeRawData(NUM_PAT_4, NUM_PAT_5, NUM_PAT_6, NUM_PAT_7);
    // mySseg.writeRawData(NUM_PAT_8, NUM_PAT_9, NUM_PAT_A, NUM_PAT_B);
    // mySseg.writeRawData(NUM_PAT_C, NUM_PAT_D, NUM_PAT_E, NUM_PAT_F);
  
    // mySseg.writeRawData(0x01, 0x02, 0x04, 0x08);
    // mySseg.writeRawData(0x10, 0x20, 0x40, 0x80);

    // mySseg.writeNum(1, 2, 0xa, 4);

    myled1 = 1;
    myled2 = 0;

    while(1) {
        for (int p = 0 ; p < sizeof(hello) ; p++) {
            myled1 = (myled1 == 0) ? 1 : 0;
            myled2 = (myled2 == 0) ? 1 : 0;
            mySseg.writeRawData(
                OVERWRAP(hello, p),
                OVERWRAP(hello, p+1),  
                OVERWRAP(hello, p+2),  
                OVERWRAP(hello, p+3));

            mySseg.updateWithDelay(200);
        }

    }
}
