#include "mbed.h"
#include "string.h"

//PINS//
//sensors
DigitalIn ss1_PIR(D3);
AnalogIn ss2_LDR(A0);
AnalogIn ss3_PIEZO(A1);
//sensors status
DigitalOut led1(D4);
DigitalOut led2(D5);
DigitalOut led3(D6);
//iD button
DigitalIn buttonID1(D3);
DigitalIn buttonID2(D3);
//ID status
DigitalOut led_ID1(D7);
DigitalOut led_ID2(D8);

//--FUNCTIONS--//
void ShowID();                      //
void ReadPIRsensor();               //DONE
void ReadLDRsensor();               //DONE
void ReadPIEZOsensor();             //DONE
void LEDstatus();
const char * PackData();
void SendDataViaWIFI();

//--GLOBAL--//
int ss1_value = 0; //percent
int ss2_value = 0; //percent
int ss3_value = 0; //percent

char sensorbox_ID[2];

int main() {
    
    ShowID();
    ReadPIRsensor();
    ReadLDRsensor();
    ReadPIEZOsensor();
    printf("PIR %d - LDR %d - PIEZO %d \n",ss1_value ,ss2_value ,ss3_value);
    
}

void ShowID()
{
    led_ID1 = buttonID1;
    led_ID2 = buttonID2;
}

void ReadPIRsensor()
{
    ss1_value = ss1_PIR*100;
}

void ReadLDRsensor()
{
    float LDR_val = ss2_LDR.read();
    ss2_value = LDR_val*100;
}

void ReadPIEZOsensor()
{
    float PIEZO_val = ss3_PIEZO.read();
    ss3_value = PIEZO_val*100;
}



