#include "mbed.h"

Serial device(D1, D0, 115200);
DigitalOut led1(LED1);
DigitalIn button0(USER_BUTTON);

void Rx_interrupt();
void SetSerial(int c);
void ConvertData();
void ResetSerial();
int PlusMinusCheck(int sign);

int data_size = 150;
char data[150] = {};
char package = 0;
char num_data = 0;
char end_data = 0;

int program;
int box_size;
int n_vp_to_front;
int n_vp_get_in;
int n_vp_get_out;
int n_all_vp;
int vp_to_front[10][5] = {};
int vp_get_in[10][5] = {};
int vp_get_out[10][5] = {};

int main()
{
    device.attach(&Rx_interrupt);

    led1 = 0;
    while(true) {
        if (package == 1) {
            package = 0;

            ConvertData();
            if(vp_get_in[1][3] == 30) {
                led1 = 1;
                wait(1);
                led1 = 0;
                wait(0.5);
            }
            ResetSerial();
        }
    }
}

void Rx_interrupt()
{
    char c = device.getc();
    int i = (int)c;
    SetSerial(i);
}
void SetSerial(int c)
{
    int i;
    int checksum = 0;
    if(num_data < 2) {
        if(c == 255) {
            data[num_data] = c;
            num_data++;
        }
    } else {
        if(c == 255) {
            data[num_data] = c;
            end_data = num_data;
            for(i=0; i<end_data-1; i++) {
                checksum = checksum + data[i];
            }
            checksum = checksum%255;
            if(checksum == data[end_data-1]) {
                package = 1;
                num_data = 0;
            }
            for(i=end_data+1; i<data_size; i++) {
                data[i] = 255;
            }
        } else {
            data[num_data] = c;
            num_data++;
        }
    }
}

void ConvertData()
{
    program = data[2];
    box_size = data[3];
    n_vp_to_front = data[4];
    n_vp_get_in = data[5];
    n_vp_get_out = data[6];
    n_all_vp = data[4]+data[5]+data[6];
    int i,j;
    int countfront = 0, countin = 0, countout = 0;
    for(i=0; i<n_all_vp; i++) {
        int start_vp = 7+9*i;
        if(i < n_vp_to_front) {
            int temp_data[9] = {};
            for(j=0; j<9; j++) {
                temp_data[j] = data[start_vp+j];
            }
            vp_to_front[countfront][0] = PlusMinusCheck(temp_data[0])*temp_data[1];
            vp_to_front[countfront][1] = PlusMinusCheck(temp_data[2])*temp_data[3];
            vp_to_front[countfront][2] = PlusMinusCheck(temp_data[4])*temp_data[5];
            vp_to_front[countfront][3] = PlusMinusCheck(temp_data[6])*temp_data[7];
            vp_to_front[countfront][4] = temp_data[8];
            countfront++;
        } else if(i < n_vp_to_front + n_vp_get_in) {
            int temp_data[9] = {};
            for(j=0; j<9; j++) {
                temp_data[j] = data[start_vp+j];
            }
            vp_get_in[countin][0] = PlusMinusCheck(temp_data[0])*temp_data[1];
            vp_get_in[countin][1] = PlusMinusCheck(temp_data[2])*temp_data[3];
            vp_get_in[countin][2] = PlusMinusCheck(temp_data[4])*temp_data[5];
            vp_get_in[countin][3] = PlusMinusCheck(temp_data[6])*temp_data[7];
            vp_get_in[countin][4] = temp_data[8];
            countin++;
        } else if(i < n_vp_to_front + n_vp_get_in + n_vp_get_out) {
            int temp_data[9] = {};
            for(j=0; j<9; j++) {
                temp_data[j] = data[start_vp+j];
            }
            vp_get_out[countout][0] = PlusMinusCheck(temp_data[0])*temp_data[1];
            vp_get_out[countout][1] = PlusMinusCheck(temp_data[2])*temp_data[3];
            vp_get_out[countout][2] = PlusMinusCheck(temp_data[4])*temp_data[5];
            vp_get_out[countout][3] = PlusMinusCheck(temp_data[6])*temp_data[7];
            vp_get_out[countout][4] = temp_data[8];
            countout++;
        }
    }
}
int PlusMinusCheck(int sign)
{
    int value;
    if (sign == 2) {
        value = -1;
    } else {
        value = 1;
    }
    return value;
}

void ResetSerial()
{
    end_data = 0;
    program = 0;
    box_size = 0;
    n_vp_to_front = 0;
    n_vp_get_in = 0;
    n_vp_get_out = 0;
    n_all_vp = 0;
    memset(vp_to_front, 0, sizeof(vp_to_front));
    memset(vp_get_in, 0, sizeof(vp_get_in));
    memset(vp_get_out, 0, sizeof(vp_get_out));
    //vp_to_front[10][5] = {};
    //vp_get_in[10][5] = {};
    //vp_get_out[10][5] = {};
}