#include "mbed.h"

Serial pc(D1,D0);

BusOut Outled(D2, D3, D4, D5, D6, D7, D8, D9);

DigitalIn in1(D10);
DigitalIn in2(D11);
DigitalIn in3(D12);

void printmenu0()
{
    pc.printf("START A-16 PROGRAM\n");
    pc.printf("[press1] Menu1\n");
    pc.printf("[press2] Menu2\n");
}

void printmenu1()
{
    pc.printf("1 LED PATTERN \n");
    pc.printf("[prees a] first_pattern \n");
    pc.printf("[prees d] second_pattern \n");
    pc.printf("[prees s] exit \n");
}

void printmenu2()
{
    pc.printf("3 INPUTS STATUS \n");
}

void menu1_A()
{
    int array1[5] = {240, 28, 6, 1,0};
    for(int i=0; i<5; i++) {
        Outled = array1[i];
        wait(0.25);
    }
}

void menu1_D()
{
    int array1[9] = {1,192,7,240,31,252,127,255,0};
    for(int i = 0; i<9; i++) {
        Outled = array1[i];
        wait(0.5);
    }
}


void menu2()
{
    pc.printf(" switch1  switch2  switch3\n");
    pc.printf("   %d       %d        %d \n ",in1.read(),in2.read(),in3.read());
    wait(1);
}

int main()
{
    int state_menu = 0;
    int state_show = 1;
    char data;

    while (true) {

        if(pc.readable()) {
            data = pc.getc();
        }

        if(state_menu == 0 && state_show ==1) {
            printmenu0();
            state_show = 0;
        }

        if (state_menu == 0 && data == '1') {
            printmenu1();
            state_menu = 1;
            state_show = 0;
        } else if (state_menu == 0 && data == '2') {
            printmenu2();
            state_menu = 2;
            state_show = 0;
        }

        if (state_menu == 1 && data == 'a') {
            menu1_A();
        } else if (state_menu == 1 && data == 'd') {
            menu1_D();
        } else if (state_menu == 1 && data == 's') {
            Outled = 0;
            state_menu = 0;
            state_show = 1;
        }

        if (state_menu == 2 && data == '2') {
            menu2();
        } else if (state_menu == 2 && data == 's') {
            state_menu = 0;
            state_show = 1;
        }


    }

}