/*
* Authors: Group 4 Adam Elghor, Brian Kaplan, Sayak Chatterjee, Moraa Onwonga
* Purpose: Controls the SETUP state of the machine
* Language: C++
*/
#include "setup.h"
#include "authentication.h"
#include "parameters.h"
#include "actuators.h"
#include "PinDetect.h"


PinDetect button(p8);

volatile bool buttonHit = false;
bool firstTime = true;

/*
* Function:  button_hit_callback
* --------------------
*  Changes boolean buttonHit inversly when called
*
*/
void button_hit_callback (void)
{
    buttonHit = !buttonHit;
}
/*
* Function:  setup
* --------------------
*  Calls the functions needed to setup the entry sequence for the safe.
*
*  returns: the next state in the state machine
*  LOCK: after entry sequence has been entered
*
*/


enum states setup()
{
    printf("%d",buttonHit);
    if (firstTime) {
        button.mode(PullUp);
        button.attach_deasserted(&button_hit_callback);
        button.setSampleFrequency();
        firstTime = false;
    }
    if(buttonHit || checkBluetooth()) {
        setEntrySequenceAttempt();
        wait(5);
        lockSafe();
        wait(5);
        return LOCK;
    }
    return SETUP;
}




