/*
* Authors: Group 4 Adam Elghor, Brian Kaplan, Sayak Chatterjee, Moraa Onwonga
* Purpose: Controls the actuators of the safe
* Language:  C++
*/
#include "actuators.h"
#include "parameters.h"
#include "Servo.h"


Servo rcServo1(p21); // pwm
Servo rcServo2(p22); // pwm
Servo middle(p23);

/*
* Function:  turnsRcServosRight
* --------------------
*  Turns the servos to the right
*
*
*/
void turnsRcServosRight() {
	printf("I entered turnsRCServoRight");
	rcServo1 = 1.0f;
	rcServo2 = 1.0f;
}

/*
* Function:  turnsRcServosLeft
* --------------------
*  Turns the servos to the right
*
*
*/
void turnsRcServosLeft() {
	rcServo1 = 0.0f;
	rcServo2 = 0.0f;
}


/*
* Function:  openSafe
* --------------------
*  Opens the safe
*/
void openSafe() {
	middle = 1.0f;
	wait(1);
	turnsRcServosRight();
}

/*
* Function:  lockSafe
* --------------------
*  Locks the safe
*/
void lockSafe() {
	turnsRcServosLeft();
	wait(3);
	middle = 1.0f;
}


