#include "mbed.h"
#include "Servo.h"
#include "rtos.h"
#include "PinDetect.h"

Servo shoulder(p26); // pwm
Servo elbow(p25); // pwm
Servo wrist(p24); // pwm
Servo hand(p23); // pwm

PinDetect button(p8);
bool buttonHit = false;

float currentShoulderPosition;
float currentElbowPosition;
float currentWristPosition;

void stroke();
void dunk();

void button_hit_callback (void) {
    buttonHit = !buttonHit;
}

int main()
{   

    currentShoulderPosition = 0.0f;
    currentElbowPosition = 0.0f;
    currentWristPosition = 0.0f;
    
    shoulder = currentShoulderPosition;
    elbow = currentElbowPosition;
    wrist = currentWristPosition;
    
    // Use internal pullup for pushbutton
    button.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.001);
    // Setup Interrupt callback function for a pb hit
    button.attach_deasserted(&button_hit_callback);
    // Start sampling pb input using interrupts
    button.setSampleFrequency();

        
        
while(1){
             
                while(buttonHit){
                dunk();
                stroke();
                wait(.1);
                }
}





}


void stroke(){
    
    while(currentShoulderPosition >0.0f){
        currentShoulderPosition -= .001f;
        shoulder = currentShoulderPosition;
        wait(.01);
        }
    

    
    for (float i = 0.0f; i < 0.5f; i+=0.01f) {
         currentWristPosition =  i/1.7f;
         currentElbowPosition = 0.19f + i/2;

        wrist = currentWristPosition;// increments to .29
        elbow = currentElbowPosition;//increments to .47
        wait(.05);


    }
    for (float i = 0.0f; i < 0.5f; i+=0.01f) {
         currentWristPosition -=  i/1.7;
         currentElbowPosition  -= i/2;
        
        wrist = currentWristPosition;//increments to 0.0f
        elbow = currentElbowPosition;//increments to .19f
        
        wait(.05);
    } 
}

void dunk(){
        
        while(currentShoulderPosition <0.3f){
        currentShoulderPosition += .001f;
        shoulder = currentShoulderPosition;
        wait(.01);
        }
        
        while(currentElbowPosition <0.3f){
        currentElbowPosition += .001f;
        elbow = currentElbowPosition;
        wait(.01);
        }

 
   
    for (float i = 0.0f; i < 0.5f; i+=0.01f) {
        
        currentWristPosition = 0.2f - i/1.5;//increments to -.2f

        wrist = currentWristPosition;


     wait(.05);

    }
    for (float i = 0.0f; i < 0.5f; i+=0.01f) {
 
        currentWristPosition = 0.2f + i/1.5;//increments to .47f
        wrist = currentWristPosition;

    wait(.05);

    } 
    
    stroke();
    
}


