#include "mbed.h" // con switch case
#include "C12832.h"
#include "Sht31.h"
 
C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
 
PwmOut speaker(p21);
AnalogIn pot(p15), pot2(p16);
DigitalOut L1(p5),L2(p6);
DigitalIn btn(p19), btn2(p20);
Sht31 sht31(I2C_SDA, I2C_SCL);

static char grafica[] = {
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01, 
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01, 
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0x80, 0x00, 0x00 , 0x00, 0x00, 0x00 , 0x00, 0x00 , 0x00, 0x00 , 0x01,
 0xff, 0xff, 0xff , 0xff, 0xff, 0xff , 0xff, 0xff , 0xff, 0xff , 0xff,
};

Bitmap grafica1 = {
  88, // XSize
  28, // YSize
  11,  // Bytes in Line
  grafica ,  // Pointer to picture data
};

void sens_vibracion() // Ejercicio 2: Sensor sismológico. Sensor: Acelerómetro ADXL202E.
{
    int valor_sensor;
    lcd.cls();
    lcd.print_bm(grafica1, 35, 4); 
    lcd.copy_to_lcd();
    L1=0;L2=0;

    float g=(pot2.read()*1.24);

    for (int b=36; b<=121; b++)
    {
        wait(0.01);
        g=(pot2.read()*1.24);
        valor_sensor = 8*pot2.read();
        lcd.pixel(b,30-valor_sensor, 1);
        lcd.locate(3, 12);
        lcd.printf("%.3fg",g);
        lcd.copy_to_lcd();
        
        if(g>=0.014 && g<0.092)
        {   
            lcd.locate(45, 3);
            lcd.printf("Sismo detectado");
            lcd.locate(40, 13);
            lcd.printf(" Ligero 4.0-4.9 R");
            lcd.copy_to_lcd();
            wait(0.1);
            lcd.locate(45, 3);
            lcd.printf("              ");
            lcd.locate(40, 13);
            lcd.printf("              ");
            lcd.copy_to_lcd();
        }
        else if(g>=0.092 && g<0.18)
        {
            lcd.locate(45, 3);
            lcd.printf("Sismo detectado");
            lcd.locate(40, 13);
            lcd.printf("Moder. 5.0-5.9 R");
            lcd.copy_to_lcd();
            wait(0.1);
            lcd.locate(45, 3);
            lcd.printf("              ");
            lcd.locate(40, 13);
            lcd.printf("              ");
            lcd.copy_to_lcd();
    ;
        }
        else if(g>=0.18 && g<0.34)
        {
            L2=1;
            lcd.locate(45, 3);
            lcd.printf("Sismo detectado");
            lcd.locate(40, 13);
            lcd.printf("Fuerte 6.0-6.9 R");
            lcd.copy_to_lcd();
            wait(0.1);
            lcd.locate(45, 3);
            lcd.printf("              ");
            lcd.locate(40, 13);
            lcd.printf("              ");
            lcd.copy_to_lcd();
            L2=0;
        }
        else if(g>=0.34 && g<1.24)
        {
            L2=1;
            lcd.locate(45, 3);
            lcd.printf("Sismo detectado");
            lcd.locate(40, 13);
            lcd.printf(" Mayor 7.0-7.9 R");
            lcd.copy_to_lcd();
            wait(0.1);
            lcd.locate(45, 3);
            lcd.printf("              ");
            lcd.locate(40, 13);
            lcd.printf("               ");
            lcd.copy_to_lcd();
            L2=0;
        }
        else if(g>=1.24)
        {
            L1=1;
            lcd.locate(45, 4);
            lcd.printf("Sismo detectado");
            lcd.locate(40, 13);
            lcd.printf("Cataclismo 8-10 R");
            lcd.copy_to_lcd();
            wait(0.1);
            lcd.locate(45, 4);
            lcd.printf("              ");
            lcd.locate(40, 13);
            lcd.printf("               ");
            lcd.copy_to_lcd();
            L1=0;
        }
    }
}
void play_tone(float frequency, float volume, float interval, float rest) 
{
    speaker.period(1.0 / frequency);
    speaker = volume;
    wait(interval);
    speaker = 0.0;
    wait(rest);
}

void sens_temp() // Ejercicio 2: Sensor de temperatura. Sensor: Sht31.
{

    lcd.cls();
    float temp = sht31.readTemperature();
    float humidity = sht31.readHumidity();
    lcd.locate(3, 3);
    lcd.printf("Temperature: %.2f C", temp);
    lcd.locate(3, 13);
    lcd.printf("Humidity: %.2f %%", humidity);
    L1 = temp > 40.0f;
    wait(0.5f); 
}

void sens_CO() //  Ejercicio 1: Concentraciñon de CO2
{
    float x;
    x = 5*pot.read();
    btn.read();
    x = 5*pot.read();
    L1=0; 
    lcd.cls();
    
    if(x >= 0.25 && x < .35)
    {
        lcd.cls();
        lcd.locate(10,3);
        lcd.printf("Niveles de C02 normales");
        lcd.locate(35,15);
        lcd.printf("%f ppm",1000*x);
        lcd.copy_to_lcd();
        play_tone(450.0, 0.1, 1, 3.5);
    }
    else if(x >= .350 && x < 1)
    {
        lcd.cls();
        lcd.locate(10,1);
        lcd.printf("Congestionado, pero con");
        lcd.locate(10,10);
        lcd.printf("buen intercambio de aire.");
        lcd.locate(35,20);
        lcd.printf("%f ppm",1000*x);
        lcd.copy_to_lcd();
        play_tone(480.0, 0.2, 1, 3);

    }
    else if(x >= 1 && x < 2)
    {
        lcd.cls();
        lcd.locate(19,7);
        lcd.printf("Calidad de aire baja");
        lcd.locate(27,17);
        lcd.printf("%f ppm",1000*x);
        lcd.copy_to_lcd();
        play_tone(500.0, 0.3, 1, 2);
    }
    else if(x >= 2 && x < 5)
    {
        lcd.cls();
        lcd.printf("Peligro");
        lcd.copy_to_lcd();
        play_tone(525.0, 0.5, 0.5, 1);

    }    
    else if(x >= 5)
    {
        L1 = 1;
        lcd.cls();
        lcd.locate(3,10);
        lcd.printf("¡Alejate!");
        lcd.copy_to_lcd();
        
        lcd.locate(45, 5);
        lcd.printf("Evacuacion");
        lcd.locate(40, 17);
        lcd.printf("de inmediata!");
        lcd.copy_to_lcd();
        
        play_tone(800.0, 5, 0.5, 0.2);
    }
    else if(x <= 0)
    {
        lcd.cls();
        lcd.locate(30,10);
        lcd.printf("Error");
        lcd.copy_to_lcd();
    }
}


 
int main() 
{ 
    printf("Práctica 7, equipo 3\n");
    float x;
    lcd.cls();
    x = 5*pot.read();
    while(x < 0.4)
    {
        x = 5*pot.read();
        wait(1);
        lcd.locate(1,1);
        lcd.printf("Precalentando %f", x);
        lcd.copy_to_lcd();
        wait(1);
        lcd.cls();
    }
    while (1)
    {
        L1=0; L2=0;
        btn2.read();
        int A=btn.read()+1;
        if (btn2==1)
        {
            A=3;
        }
        
        switch (A)
        {
            case 1: sens_CO();
            break;
            case 2: sens_temp();
            break;
            case 3: sens_vibracion(); 
            break;
        }
        wait_ms(500);
    }
}