#include "mbed.h"


void button_FSM( void );
void max31855( void );
void init_max31855( void );

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn  button(p21);
AnalogIn   Ain1(p19);
AnalogIn   Ain2(p20);
Serial     pc(USBTX, USBRX);
DigitalOut spi_clk(p7);
DigitalOut spi_cs(p8);
DigitalIn  spi_data(p6);
LocalFileSystem local("local");

int enable;
int button_state;
int record_state;
int spi_data_in_temp;
int spi_data_in;
float A1, A2, B1, B2;
time_t seconds = 0;
int openFile = 0;
int closeFile = 0;

int main()
{
    // Opens the root directory of the local file system
    pc.printf("Files on mbed\r\n");
    DIR *d = opendir("/local");
    struct dirent *p;
    while((p = readdir(d)) != NULL)
    {                                             // Print the names of the files in the local file system
        pc.printf("%s\n\r", p->d_name);            // to stdout (USB Serial).
    }
    closedir(d);
    pc.printf("\n");    
    // Removes the file "log.csv" from the local file system
    //remove("/local/log.csv");
    // Open "log.csv" on the local file system for writing
    FILE *fp = fopen("/local/log.csv", "a");
    //Send headers to csv file
    fprintf(fp, "Time_Seconds,T1_C,T2_C,T3_C\r");

    enable = 0;
    button_state = 0;
    record_state = 0;
    init_max31855();
    
    pc.printf("Data Logger Ready\r\n");
    
    while(closeFile == 0)
    {
        wait(1.0);
        button_FSM();
        max31855();
              
        if( enable == 1 )
        {
            A1 = Ain1.read_u16();
            B1 = (0.000000029*(A1*A1))-(0.00341*A1)+104;
            A2 = Ain2.read_u16();
            B2 = (0.000000029*(A2*A2))-(0.00341*A2)+104;
            pc.printf("Ain1=%.2f Ain2=%.2f t'c=%d\r\n", B1, B2, spi_data_in);
        }
        //get time in seconds
        seconds = time(NULL);
        //and save to log file
        fprintf(fp, "%d,%.2f,%.2f,%d\n", seconds, B1, B2, spi_data_in );
    }
    fclose(fp);
}

void max31855( void )
{
    int bits = 0;

    spi_data_in_temp = 0;

    spi_clk = 0;
    spi_cs = 0;
    wait(0.01);
    
    while( bits < 32 )
    {
        spi_clk = 1;
        spi_clk = 1;
        if( bits > 0 && bits < 12 )
        {
            spi_data_in_temp = (spi_data_in_temp *2) + spi_data;
        }
        spi_clk = 0;
        bits++;
    }
    spi_data_in = spi_data_in_temp;
    spi_cs = 1;
}

void init_max31855( void )
{
    spi_cs = 1;
    spi_clk = 0;
    spi_data_in_temp = 0;
    spi_data_in = 0;
}

void button_FSM( void )
{
    if( enable == 0 )
    {
        switch( button_state )
        {
            default:
            case 0:
                if( button == 1 )
                    button_state = 1;
                else
                    button_state = 0;
                break;
                
            case 1:
                if( button == 1 )
                    button_state = 2;
                else
                    button_state = 0;
                break;
                
            case 2:
                if( button == 1 )
                    button_state = 3;
                else
                    button_state = 0;
                break;
                
            case 3:
                if( button == 1 )
                    button_state = 4;
                else
                    button_state = 0;
                break;
                
            case 4:
                enable = 1;
                button_state = 0;
                pc.printf("Recording...\r\n");
                //reset time to zero
                set_time(0);
                break;
        }
    }
    else
    {
        switch( button_state )
        {
            default:
            case 0:
                if( button == 1 )
                    button_state = 1;
                else
                    button_state = 0;
                break;
                
            case 1:
                if( button == 1 )
                    button_state = 2;
                else
                    button_state = 0;
                break;
                
            case 2:
                if( button == 1 )
                    button_state = 3;
                else
                    button_state = 0;
                break;
                
            case 3:
                if( button == 1 )
                    button_state = 4;
                else
                    button_state = 0;
                break;
                
            case 4:
                enable = 0;
                button_state = 0;
                closeFile = 1;
                pc.printf("STOPPED!\r\n");
                break;
        }
    }
    switch( button_state )
    {
        default:
        case 0:
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
            
        case 1:
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
            
        case 2:
            led1 = 1;
            led2 = 1;
            led3 = 0;
            led4 = 0;
            break;
            
        case 3:
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 0;
            break;
            
        case 4:
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
            break;
    }
}
