#include "WiGo_BattCharger.h"
#include "mbed.h"

WiGo_BattCharger::WiGo_BattCharger( PinName battlow, PinName battmed, PinName battfull, PinName en1, PinName en2, PinName snsen, PinName sense, PinName supplystate, PinName chargestate ) : _battlow(battlow), _battmed(battmed), _battfull(battfull), _en1(en1), _en2(en2), _snsen(snsen), _sense(sense), _supplystate(supplystate), _chargestate(chargestate)
{
    _battlow = BATT_LED_OFF; //Default State
    _battmed = BATT_LED_OFF;
    _battfull = BATT_LED_OFF;
    _en1 = 0;               //100mA Charge
    _en2 = 0;
    _snsen = 1;             //Off
}

void WiGo_BattCharger::init( int n )
{
    switch(n) {
        default:
        case 0: //100mA Charge
            _en1 = 0;
            _en2 = 0;
            break;

        case 1: //500mA
            _en1 = 0;
            _en2 = 1;
            break;

        case 2: //724mA
            _en1 = 1;
            _en2 = 0;
            break;

        case 3: //Suspend
            _en1 = 1;
            _en2 = 1;
            break;
    }
}

void WiGo_BattCharger::sense_en( int n)
{
    if( n == 0 )
        _snsen = 1;
    else
        _snsen = 0;
}

float WiGo_BattCharger::read( void )
{
    return _sense;
}

int WiGo_BattCharger::charging( void )
{
    return _chargestate;
}

int WiGo_BattCharger::supply( void )
{
    return _supplystate;
}

void WiGo_BattCharger::LEDupdate( int n )
{
    float batt_level;

    if( n == 1 ) {
        sense_en(1);
        batt_level = read();
        if( batt_level <= BATT_0 ) {
            _battlow = BATT_LED_OFF;
            _battmed = BATT_LED_OFF;
            _battfull = BATT_LED_OFF;
        }
        if( batt_level > BATT_0 && batt_level <= 0.605 ) {
            _battlow = BATT_LED_ON;
            _battmed = BATT_LED_OFF;
            _battfull = BATT_LED_OFF;
        }
        if( batt_level > 0.605 && batt_level <= BATT_100 ) {
            _battlow = BATT_LED_ON;
            _battmed = BATT_LED_ON;
            _battfull = BATT_LED_OFF;
        }
        if( batt_level > BATT_100 ) {
            _battlow = BATT_LED_ON;
            _battmed = BATT_LED_ON;
            _battfull = BATT_LED_ON;
        }
    }
    else
    {
         _battlow = BATT_LED_OFF;
         _battmed = BATT_LED_OFF;
         _battfull = BATT_LED_OFF;
    }
}

int WiGo_BattCharger::level( void )
{
    float returnValue = 0;
    float batt_level = read();

    returnValue = ((batt_level - BATT_0) * (BATT_100 - BATT_0)) * 10000;

    if( returnValue > 100 )
        returnValue = 100;

    if( returnValue < 0 )
        returnValue = 0;

    return (int)returnValue;
}
