// Hello World! for the TextLCD

#include "mbed.h"
#include "TextLCD.h"
#include "TMP102.h"

DigitalOut blue_led(LED1);
DigitalOut speaker(p21);

TMP102 temperature(p9, p10, 0x92); //A0 pin is connected to ground
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7

int main() {
    
    char buffer[32];
    time_t seconds = time(NULL);
    
    set_time(1256729737);
    printf("%s\n", buffer);
    lcd.cls();
    for (int i = 0 ; i <= 100 ; i += 1 )
    {
        speaker = !speaker;
        wait (0.001); // 5kHz, with 10 steps
    }
    for (int i = 0 ; i <= 50 ; i += 1 )
    {
        speaker = !speaker;
        wait (0.002); // 5kHz, with 10 steps
    }
    
    
    while(1)
    {
        lcd.cls();
        seconds = time(NULL);
        strftime(buffer, 32, "%X", localtime(&seconds));
        lcd.printf("%s\n", buffer);
        //printf("%s\n", buffer);
        lcd.printf("Temp: %f\n", temperature.read());
        blue_led = 1;
        wait(0.5);
        blue_led = 0;
        wait(0.5);
    }
    
    //while (1)
    //{
    //     speaker = !speaker;
    //     wait (0.001); // 5kHz
    //}
    
    
}
