#include "mbed.h"
#include "micro.h"

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);

FILE *fp;

int main() {
    led_1 = 1;
    led_2 = 1;
    led_3 = 1;
    led_4 = 1;
    wait(1);
    pc.printf("\nJTAG Programmer\nLooking for /local/XSVF.bit\n");
    led_1 = 0;
    led_2 = 0;
    led_3 = 0;
    led_4 = 0;
    wait(1);
    led_1 = 1; //Program Started

    fp = fopen("/local/XSVF.bit", "rb");

    if (fp == NULL) {
        pc.printf("Failed to open file\n");
        while(1) //blink LED2 as a error
        {
            led_2 = 1;
            wait(1);
            led_2 = 0;
            wait(0.2);
        }
    } else {
        pc.printf("Binary file opened successfully\n");
        led_2 = 1; // file open, starting programming progress
        xsvfExecute();
        fclose(fp);
    }

    pc.printf("Programming complted\n");
    while(1)
    {
        led_4 = 1;
        wait(1);
        led_4 = 0;
        wait(0.2);
    }
}
