#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
//#include "TSISensor.h"
#define addr (0x1D<<1)

Serial pc(USBTX, USBRX); // tx, rx
MMA8451Q acc(PTE25, PTE24, addr); //accelerometer 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
//TSISensor tsi;

int main()
{
    float x=0;
    float y=0;
    int x1,y1;
    //float z=0;
    //float sensor=0;
    char buff[2]; // make it 4
    char TxDataCnt;
    char temp;

    //set tx and rx address for pipe0: 5 bytes long; different for every pipe
    long long TxAddress_PIPE0 = 0xE7E7E7E7E7;
    long long RxAddress_PIPE0 = 0xE7E7E7E7E7;
    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2425);
    
    //setting tx and rx address
    my_nrf24l01p.setTxAddress(TxAddress_PIPE0);
    
    //set rx address with default width and pipe number
    my_nrf24l01p.setRxAddress(RxAddress_PIPE0, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P0);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
    pc.printf( "Wireless Sensor Network - Mouse Transmitter\r\n" );

    TxDataCnt = 10; //make it 4
    my_nrf24l01p.setTransferSize(TxDataCnt);

    my_nrf24l01p.enable();


    while (1) {


        x=acc.getAccX(); //X-axis value
        y=acc.getAccY(); //Y-axis value
        //z=acc.getAccZ(); //Z-axis value
        x1=x*30;
        y1=y*30;
        //z1=z*5;
        
        //sensor=tsi.readPercentage();
        //s=sensor*100;
        
        pc.printf("\r\n x = %f y = %f ",x,y);
        pc.printf("\r\n x1 = %d y1 = %d",x1,y1);
    
        
        
        buff[0] = x1; 
        buff[1] = y1; 
        //buff[2] = z1;
        //buff[3] = s;
        
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,buff, TxDataCnt );
        pc.printf("\r\n%d byte x= %d y= %d",temp,buff[0],buff[1]); // add buff[2 & 3]
        
        //wait_ms(1);
    }
}
