#include "mbed.h"
#include "nRF24L01P.h"
#include "USBMouse.h"
 
Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut led(LED1);
USBMouse mouse; 

int main() {
    
    char buff[2]; //make it 4
    char RxDataCnt_PIPE0;
    int x=0;
    int y=0;
    //int z=0;
    //int sensor=0;
    char temp;
    
    
    //specifying address same as transmitter for pipe0 and pipe1
    long long RxAddress_PIPE0 = 0xE7E7E7E7E7;
    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2425);
    
    //set rx address with default address and for specified pipe
    my_nrf24l01p.setRxAddress(RxAddress_PIPE0, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P0);
    
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ RX Address - PIPE0  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "Wireless Sensor Network - Mouse Reciever\r\n" );
    
    RxDataCnt_PIPE0 = 10; //make it 4
   
    
    //set transfer size explicitly for both pipes

    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE0, NRF24L01P_PIPE_P0);
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
 
    //int s=10;
    
    while (1) {
        
        //check if data is available in pipe0
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {
            
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, buff, RxDataCnt_PIPE0 );
            x=buff[0];
            y=buff[1];
            //z=buff[2];
            //sensor = buff[3];
            
            if(x>100)
            {
                x=x-256;
            }
            if(y>100)
            {
                y=y-256;
            }
            
            mouse.move(-y,x);
            
            pc.printf("\n%d byte recieved: x=%d y=%d",temp,x,y);
            
            led = !led;
            
            //wait_ms(100);
            /*
            if(sensor<35 && sensor>1)
            {
            mouse.press(MOUSE_RIGHT);
            }
            else
                {
                mouse.release(MOUSE_RIGHT);
                }    
            if(sensor<100 && sensor>65)
            {
            mouse.press(MOUSE_LEFT);
            }
            else
                {
                mouse.release(MOUSE_LEFT);
                }      
            if(sensor>36 && sensor<64)
            {
            mouse.press(MOUSE_MIDDLE);
            mouse.scroll(z);
            }
            else
                {
                mouse.release(MOUSE_MIDDLE);
                }*/ 
        }
        
       
    }
}