/*****Multiceiver wireless network with IoT*****/
 
#include "mbed.h"
#include "nRF24L01P.h"
#include "ESP8266.h"
 
//Serial Transmission
Serial pc(USBTX, USBRX); // tx, rx
 
//wifi UART port and baud rate
ESP8266 wifi(PTE0, PTE1, 115200); 
 
//nRF module 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
 
//blue for pipe1 and green for pipe0
DigitalOut GreenLED(LED2);
DigitalOut RedLED(LED1);
 
//buffers for wifi library
char snd[255],resp[1000];
char http_cmd[300], comm[300];
int timeout = 6000; //timeout for wifi commands
 
char count[1];
char RxDataCnt_PIPE0, RxDataCnt_PIPE1;
char temp;
 
//potvalue and ldrvalue
char pot_val, ldr_val;
float potval, ldrval;
float opv=0;
float olv=0;
 
//Public and private keys for phant
char* Public_Key = "wrZ1PpONOpCk1QPM03wki1yDdZXb";
char* Private_Key = "OzYl9EOZOEcvPZ3Wbxjvs3A7OpXM";
    
//SSID and password for connection
#define SSID "Eduvance_WiFi"
#define PASS "eduvance"

//Remote IP
#define IP "192.168.0.2" //184.106.153.149-ThingsSpeak IP
 
//Wifi init function
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}
 
void wifi_send(void){
    
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP, 8080);  //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    
    //create link 
    sprintf(http_cmd,"/input/%s?private_key=%s&ldr=%0.2f&pot=%0.2f",Public_Key,Private_Key,ldrval,potval); 
    //sprintf(http_cmd,"/input/%s?private_key=%s&ldr=%.2f&pot=%.2f",Public_Key,Private_Key,ldrval,potval); 
    pc.printf(http_cmd);
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while sending URL \r\n");
    
}
 
int main() {
    
    
    //specifying address same as transmitter for pipe0 and pipe1
    long long RxAddress_PIPE1 = 0xE2E2E2E2E2;
    long long RxAddress_PIPE0 = 0xC2C2C2C2C2;
    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2475);
    
    //set rx address with default address and for specified pipe
    my_nrf24l01p.setRxAddress(RxAddress_PIPE1, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P1);
    my_nrf24l01p.setRxAddress(RxAddress_PIPE0, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P0);
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    
    //display rx address for both pipes
    pc.printf( "nRF24L01+ RX Address - PIPE0  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "nRF24L01+ RX Address - PIPE1  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P1) );
    pc.printf( "Wireless Sensor Network - Multiceiver\r\n" );
    
    RxDataCnt_PIPE0 = 1;
    RxDataCnt_PIPE1 = 1;
    
    //set transfer size explicitly for both pipes
    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE1, NRF24L01P_PIPE_P1);
    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE0, NRF24L01P_PIPE_P0);
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    wifi_initialize();
 
    while (1) {
        
        //check if data is available in pipe0
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {
 
            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt_PIPE0 );
            
            pot_val = count[0];
            potval=pot_val;
            
            pc.printf("Received: %d bytes from PIPE0; POT=%d\r\n",temp, potval);
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            GreenLED = !GreenLED;
        }
        
        //check if data is there in pipe1
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P1) ) {
 
            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P1, count, RxDataCnt_PIPE1 );
            
            ldr_val = count[0];
            ldrval=ldr_val; 
            pc.printf("Received: %d bytes from PIPE1; LDR=%d\r\n",temp, ldrval);
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            RedLED = !RedLED;
        }
        if(olv!=ldrval || opv!=potval)
        {
        wifi_send();
        }
        olv=ldrval;
        opv=potval;
        }
}