#include "mbed.h"
#include "GVD.hpp"
#include "BitAccess.h"

char read_address() {
    const size_t din_num = 4;
    DigitalIn din[] = {
        DigitalIn(dp26),
        DigitalIn(dp25),
        DigitalIn(dp18),
        DigitalIn(dp17)
    };

    char address = 0;
    size_t address_offset = 0x08 << 1;
    for (size_t i = 0; i < din_num; ++i) {
        address |= din[i].read() << (i + 1);
    }
    return address + address_offset;
}
 
int main(){
    I2CSlave i2c(dp5, dp27);
    i2c.address(read_address());
    GVD vd(dp11,dp2,dp9,dp6,dp4,dp10,dp1,dp13);
    BitAccess byte;
    while (true){
        char buf;
        switch (i2c.receive()){
            case I2CSlave::ReadAddressed:
                break;
            case I2CSlave::WriteGeneral:
                break;
            case I2CSlave::WriteAddressed:
                i2c.read(&buf, 1);
                byte.setByte(buf);
                vd.write(byte.b0,byte.b1,byte.b2,byte.b3,byte.b4,byte.b5,byte.b6,byte.b7);
                break;
            case I2CSlave::NoData:
                break;
        }
    }
}