#include "mbed.h"
#include "Serial.h"

Serial lcd(p9, p10); // tx, rx
void clear(void);
void move_cursor(int, int);



DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut armDown(p21);
DigitalOut armUp(p22);
DigitalIn onSwitch(p30);
DigitalIn runSwitch(p29);
DigitalIn upSwitch(p28);
DigitalIn downSwitch(p27);


int main() {
/* State 1: Rest
    State 2: Down
    State 3: Wait2
    State 4: Up */
    wait(1);
    clear();
    lcd.printf("Seatbelt Test");
    int state = 1;
    int count = 0;
    int maxCount = 1000;
    float wait1 = 5.0;
    float wait2 = 5.0  ;
    float cylDown = 2.0;
    float cylUp = 2.0;
    while(1) {
    while((onSwitch==1)&&(count<=maxCount)) {
        move_cursor(1,0);
        lcd.printf("                ");
        move_cursor(1,0);
        lcd.printf("%d Out of:%d",count,maxCount);
        
        if(runSwitch==1) {
            if(state==1) { // State 1 Wait
            armDown = 0;
            myled1 = 0;
            armUp = 0;
            myled2 = 0;
            wait(wait1);
            state = 2;
            }
            else if(state==2) { // State 2 Arm Down
            armDown = 1;
            myled1 = 1;
            armUp = 0;
            myled2 = 0;
            wait(cylDown);
            state = 3;
            }
            else if(state==3) { // State 3 Wait
            armDown = 0;
            myled1 = 0;
            armUp = 0;
            myled2 = 0;
            wait(wait2);
            state = 4;
            }
            else if(state==4) { // State 4 Arm Up
            armDown = 0;
            myled1 = 0;
            armUp = 1;
            myled2 = 1;
            wait(cylUp);
            state = 1;
            count++;
            }
                
        }
        else if(runSwitch==0) {
            if(upSwitch==1) {
            armUp = 1;
            myled2 = 1;
            armDown = 0;
            myled1 = 0;
            }
            else if(downSwitch==1) {
            armUp = 0;
            myled2 = 0;
            armDown = 1;
            myled1 = 1;
            }
            else {
            armUp = 0;
            armDown = 0;
            myled1 = 0;
            myled2 = 0;
            }
        }
    }
    }
}
//------clears the dispaly--------
void clear(void) {
    lcd.putc(0xFE);
    lcd.putc(0x01);
}
 
//----------- line 0 or 1----------
//----------- position 0/15--------
// (0,0) is top left position
// (1,15) is bottom right position
void move_cursor(int line, int pos) {
    int cp;
    cp = pos + (line * 64) +128;
    lcd.putc(0xFE);
    lcd.putc(cp);
}
