#include "mbed.h"
#include "rtos.h"

typedef struct {
    float voltage;
    float current;
    uint32_t counter;
} message_t;

MemoryPool<message_t, 4> mpool;
Queue<message_t, 4> queue;

void send_thread(void const *args)
{
    const uint32_t WAIT_MS = 1000;
    
    uint32_t i = 0;
    while (true) {
        i++;
        message_t* message = mpool.alloc();
        while (!message) {
            // 古い情報は消す
            osEvent evt = queue.get();
            mpool.free((message_t*)evt.value.p);

            message = mpool.alloc();
        }

        message->voltage = (i * 0.1) * 33;
        message->current = (i * 0.1) * 11;
        message->counter = i;
        queue.put(message);

        Thread::wait(WAIT_MS);
    }
}

int main()
{
    const uint32_t NO_WAIT = 0;
    const int INTERVAL_MS = 4000;

    Timer timer;

    Thread thread(send_thread);

    timer.start();
    while (true) {
        timer.reset();

        for (osEvent evt = queue.get(NO_WAIT); evt.status == osEventMessage; evt = queue.get(NO_WAIT)) {
            message_t* message = (message_t*)evt.value.p;
            printf("\nVoltage: %.2f V\n\r", message->voltage);
            printf("Current: %.2f A\n\r", message->current);
            printf("Counter: %u\n\r", message->counter);

            mpool.free(message);
        }

        while (timer.read_ms() < INTERVAL_MS) {
            Thread::yield();
        }
    }
}
