#include "mbed.h"
#include "EthernetInterface.h"
 
#define ECHO_SERVER_PORT   3434

DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p30, p29);
 
int main (void) {
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("Server IP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    can1.frequency(125000);

    CANMessage msg;
    
    while (true) 
    {
        printf("\nWait for new connection...\n\r");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n\r", client.get_address());
        char buffer[256];
        while (true) 
        {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n\r",buffer);
            
             
                if(can1.write(CANMessage(0x200,buffer,1)))
                {   
                led1 = 1;
                }
            
            
            
            if(can1.read(msg)) 
            {
            printf("Message received: %d\n", msg.data[0]);
            led2 = !led2;
            } 
            
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\n\r",buffer);
            
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        led1 = 0;
        client.close();
    }
}
 