#include "mbed.h"
#include "string.h"
#include "DHT11.h"

#define TEMPERATURE_OFFSET 0.0f    //in degrees +- temperature from the mean point
#define GROUND_HUMIDITY_OFFSET 0.0f//in percentage

//for reference and real values
// 0 - inside temperature, 1 - inside humidity, 2 - ground humidity, 3 - light intensity

//for actuator
// 0 - heater (digital), 1 - ventilator(digital), 2 - water valve(digital), 3 - LEDs(analogue)

//-----------------------------Ini Classes-----------------------------
Serial bt(D10, D2);     //initiate bluetooth
Serial pc(USBTX,USBRX); //and pc serial connections
DigitalOut myled(LED1); //and an LED
PwmOut light(D11);   
DigitalOut valve(D4);
DigitalOut heater(D5);
DigitalOut ventilator(D6);

AnalogIn lightSensor(A0);
AnalogIn humiditySensor(A1);
DHT11 dht(A2);
//------------------------Function prototypes--------------------------
void onRequest();
void onUpdate();
void compareLight();
void compareMoisture();
void compareTemperature();
void senseLight();
void senseMoisture();
void senseDHT11();
//-------------------------------------ISR-----------------------------
    char word[11];
    float reference[4];
    float real[4];
    float actuator[4];

void ISR()
{
    if(bt.readable()) {
         bt.scanf ("%10s", word);
         if (strcmp(word, "request")==0)
        {
            onRequest();
        }
        if (strcmp(word, "update")==0)
        {
            onUpdate();   
        }
    }   
}

//-----------------------------------MAIN------------------------------
int main()
{
    light.period_ms(20);
    reference[0] = 25;  //temperature
    reference[1] = 25; //air humidity
    reference[3] = 55;  //light intensity
    reference[2] = 30;  //ground humidity
    
    bt.baud(9600);
    pc.baud(115200);
    
    bt.attach(&ISR);    //attach an interrupt on a bt serial connection      
    light = 0.0;

    pc.printf ("Oh well...\n");
    real[3] = 0.0;
    while(1) {
        //here disable interrupts
      //  __disable_irq();
        
        senseLight();
        senseMoisture();
        senseDHT11();

        pc.printf ("temp=%.2f, hum=%.2f, moist=%.2f, inten=%.2f\n", real[0], real[1], real[2], real[3]);
        
        compareLight ();
        compareMoisture ();
        compareTemperature();

        //here enable interrupts
      //  __enable_irq();
        
        wait(3.0f);
    }
}

//--------------------------------Functions------------------------------------------
//*********************************REQUEST info from sensors*************************
void onRequest()
{
 //   bt.printf ("%d\n", 1);
    //bt.printf ("temp=%.1f, hum=%.1f, groundHum=%.1f, inten=%.1f\n", 10.0, 20.0, 30.0, 40.0);
   // for (int i = 0; i < 4; i++)
   // {
     //   bt.printf ("%.2f\n", real[i]);   
     //   bt.printf ("%d\n", (int)real[i]); 
   // }
    bt.printf ("%d\n", (int)real[0]); 
    bt.printf ("%d\n", (int)real[1]); 
    bt.printf ("%d\n", (int)real[2]); 
    bt.printf ("%d\n", (int)real[3]); 
}
//***********************************UPDATE info from phone**************************
void onUpdate()
{
    int i = 0;
    char buff;
    
    while(true)
    {
        if (bt.readable())  //read off 4 values - references
        {
            if(!bt.scanf ("%f", &reference[i]))
                bt.scanf ("%c", &buff);     //if not float, put info buffer and through out..
            else
                i++;
        }
        if (i == 4) break;  //after getting enough values go back to normal loop
    }
    pc.printf ("%.1f, %.1f, %.1f, %.1f\n", reference[0], reference[1], reference[2], reference[3]);
}
//******************************LIGHT intensity function*****************************
void compareLight()
{
    if ((reference[3] > real[3]) && (light < 1.0f)) //if not enough of light - turn on additional light little by little  
        light =  light + 0.05f;  
    else if ((reference[3] < real[3]) && (light > 0.0f)) //if enough of light - turn off the light little by little
        light = light - 0.05f;
}
//****************************GROUND moisture detection*****************************
void compareMoisture()
{
    if (reference[2] - GROUND_HUMIDITY_OFFSET > real[2])    //if moisture drops below the reference - offset, turn on valve with water
        valve = 1;
    else 
        valve = 0;
}
//*****************************TEMPERATURE sensor************************************
void compareTemperature()
{
    if (reference[0] + TEMPERATURE_OFFSET < real[0])    //if above the reference + offset, turn on ventilator
    {
        ventilator = 1;
        heater = 0;
    }
    else if (reference[0] - TEMPERATURE_OFFSET > real[0]) //if below reference - offset, then turn on heater
    {
        ventilator = 0;
        heater = 1;
    }  
    else        //else let the plants grow!
    {
        heater = 0;
        ventilator = 0;
    }
}
//******************************************READ LIGHT*******************************
void senseLight()
{
    real[3] = lightSensor.read()*100.0;
}
//*****************************************READ Moisture*****************************
void senseMoisture()
{
    real[2] = (1.0-humiditySensor.read())*100.0;
}
//****************************************READ temperature***************************
void senseDHT11()
{
    int s = dht.readData();
    if (s != DHT11::OK) 
    {
        printf("Error!\r\n");
    }
    else 
    {
        real[0] = dht.readTemperature();
        real[1] = dht.readHumidity();
    }
}