#include "mbed.h"
#include "USBHostKeyboard.h"
#include <string>
#include "error.h"

#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 512
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 1024

#include "MODSERIAL.h"
#include "uLCD_4DGL.h"

DigitalOut myled(LED1);
MODSERIAL xbee(p9, p10);
DigitalOut reset(p20);
DigitalOut type(p19);
MODSERIAL pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

uLCD_4DGL lcd(p13,p14,p15);

string s = "";

void clearLastChar() {
    lcd.color(BLACK);            
    lcd.locate(lcd.current_col-1, lcd.current_row);
    lcd.putc(' ');
    lcd.locate(lcd.current_col-1, lcd.current_row);
}

void onKey(uint8_t key)
{
    if (key == '\n') {
        led3 = 0;
        xbee.printf("%s\r", s);
        s = "";
        lcd.cls();
    } else if (key == 8) {
        if (lcd.current_col > 0) {
            clearLastChar();
            s = s.substr(0,s.length()-1);
        }
    } else {
        s += key;
        led3 = 1;
        lcd.color(WHITE);
        lcd.putc(key);
    }
}

void keyboard_task(void const *)
{

    USBHostKeyboard keyboard;

    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);

        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);

        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
    }
}

int num = 0;

int main()
{
    lcd.baudrate(3000000);
    reset = 0;
    wait_ms(1);
    reset = 1;
    wait_ms(1);

    if (!type) {
        while(1) {
            led2 = !led2;

            if (xbee.readable()) {
                ++num;
                if (num >= 2) {
                    lcd.cls();
                    num = 0;
                }
                lcd.printf("Got new Message:\n");
                while (xbee.readable()) {
                    //pc.putc(xbee.getc());
                    char buffer[512];
                    xbee.scanf("%s", buffer);
                    lcd.printf("%s ", buffer);
                    wait_ms(1);
                }
                lcd.printf("\n\n");
                led3 = !led3;
            }
            wait_ms(20);
        }
    } else {
        Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
        while(1);
    }

}
