#include <vector>
#include <string>
#include "mbed.h"
#include "wave_player.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"
#include "USBHostMSD.h"
#include "rtos.h"

#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 512
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 1024

#include "MODSERIAL.h"

using namespace std;

MODSERIAL device(p13,p14);
MODSERIAL pc(USBTX, USBRX);

AnalogOut DACout(p18);
wave_player waver(&DACout);

uLCD_4DGL screen1(p28, p27, p11);
uLCD_4DGL screen2(p9, p10, p11);

Mutex mutex;

volatile bool playAlarm = false;

void musicThread(void const*);

void getDate()
{
    //mutex.lock();
    device.printf("date\n");
    //pc.printf("Requesting date\n");
    //mutex.unlock();
}

void getTime()
{
    //mutex.lock();
    device.printf("time\n");
    //pc.printf("Requesting time\n");
    //mutex.unlock();
}

void getAlarm()
{
    //mutex.lock();
    device.printf("alarm\n");
    //pc.printf("Requesting Alarm\n");
    //mutex.unlock();
}

string date;
string t;
volatile bool playingMusic = false;

void printDate()
{
    // TODO - IMPLEMENT THIS SHIT
}

void printTime()
{
    // TODO - IMPLEMENT THIS SHIT
}

/*void playAlarm()
{
    //if (playingMusic) return;
    //Thread music(musicThread, NULL, osPriorityNormal, 1024 * 4);

}*/

void timeThread(void const* args)
{
    //screen1.locate(0,5);
    //screen1.color(WHITE);
    //screen1.textbackground_color(RED);
    //screen1.printf("I AM IN THE THREAD\n");

    getDate();
    while (!device.readable());
    char buffer[80];
    device.scanf("%s", buffer);
    date = string(buffer);
    char buffer2[80];
    device.scanf("%s", buffer2);
    date += (" " + string(buffer2));
    char buffer3[80];
    device.scanf("%s", buffer3);
    date += (" " + string(buffer3));

    printDate();

    while (1) {
        getTime();
        while (!device.readable());
        char buffert[80];
        device.scanf("%s", buffert);
        t = string(buffert);

        printTime();

        getAlarm();
        while (!device.readable());
        char buffera[20];
        device.scanf("%s", buffera);
        if (buffera[0] == '1') {
            playAlarm = true;
        }

        Thread::wait(6000);
    }
}

void musicThread(void const *args)
{
    if (playingMusic) return;
    USBHostMSD msd("usb");
    while (1) {
        while (!playAlarm);

        playingMusic = true;
        //pc.printf("Playing\n");
        
        //pc.printf("USB\n");
        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }
        //pc.printf("Connected\n");
        FILE * fp = fopen("/usb/sample.wav", "r");

        if (fp != NULL) {
            waver.play(fp);
            fclose(fp);
        } else {
        }
        
        playAlarm = false;
        playingMusic = false;
    }
}


void setupScreens()
{
    screen1.baudrate(3000000);
    screen1.cls();
    screen2.baudrate(3000000);
    screen2.cls();
}


int main()
{
    setupScreens();

    screen1.locate(0,5);
    screen1.color(WHITE);
    screen1.textbackground_color(RED);
    screen1.printf("Song Playing\n");

    Thread thread(musicThread, NULL, osPriorityNormal, 1024 * 4);
    Thread tThread(timeThread);

    while (1);
}