#include <string>
#include "weather.h"
#include "EthernetInterface.h"
#include "rtos.h"
#include <sstream>
#include "mbed.h"
#include <vector>
#include <functional>
#include <iostream>

using namespace std;

weatherInfo currentWeather;

void split(const string& s, char c,
           vector<string>& v)
{
    string::size_type i = 0;
    string::size_type j = s.find(c);

    while (j != string::npos) {
        v.push_back(s.substr(i, j-i));
        i = ++j;
        j = s.find(c, j);

        if (j == string::npos)
            v.push_back(s.substr(i, s.length()));
    }
}

weatherInfo getWeatherInfo()
{
    TCPSocketConnection sock;
    sock.connect("ece4180.cloudapp.net", 80);
    //sock.connect("google.com", 80);

    char http_cmd[] = "GET /weather.php HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
    }
    sock.close();

    vector<string> v;
    string s(buffer);

    split(s, '|', v);
    
    currentWeather.zipcode = v[1].c_str();
    currentWeather.tempC = atof(v[2].c_str());
    currentWeather.tempF = (9.0*currentWeather.tempC/5.0) + 32.0;
    currentWeather.condition = v[3];
    currentWeather.clouds = atof(v[4].c_str());
    currentWeather.windSpeedKm = atof(v[5].c_str());
    currentWeather.windSpeedMi = currentWeather.windSpeedKm/1.609344;

    return currentWeather;
}