#include "alarm.h"
#include <string>
#include "EthernetInterface.h"
#include "mbed.h"

using namespace std;

alarmTime nextAlarm;

alarmTime getAlarmTime() {
    
    TCPSocketConnection sock;
    sock.connect("ece4180.cloudapp.net", 80);

    char http_cmd[] = "GET /alarm.php HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
    }
    sock.close();
    
    string t(buffer);
    t = t.substr(t.find("\r\n\r\n")+4);
    printf("Time: %s\n", t);
    nextAlarm.full = t;
    nextAlarm.hour = atoi(t.substr(0,2).c_str());
    printf("Hour: %d\n", nextAlarm.hour);
    nextAlarm.minute = atoi(t.substr(3).c_str());
    printf("Minute: %d\n", nextAlarm.minute);
    
    return nextAlarm;
}

string isItAlarmTime(time_t *t) {
    
    //alarmTime at = getAlarmTime();
    getAlarmTime();
    int hour = localtime(t)->tm_hour-4;
    int min = localtime(t)->tm_min;
    
    printf("MBED Time: %d:%d\n", hour, min);
    printf("Server Time: %d:%d\n", nextAlarm.hour, nextAlarm.minute);
    
    return (((hour == nextAlarm.hour) && (min == nextAlarm.minute)) ? "1" : "0");
}