#include <string>
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "EthernetInterface.h"
#include "rtos.h"
#include "alarm.h"
#include <sstream>
#include "weather.h"
#include "NTPClient.h"
#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 512
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 1024

#include "MODSERIAL.h"

MODSERIAL device(p13,p14);

NTPClient ntp;
time_t ctTime;

EthernetInterface eth;
AnalogIn tempSensor(p15);

uLCD_4DGL screen1(p28, p27, p11);
uLCD_4DGL screen2(p9, p10, p11);

Mutex mutex1;
Mutex mutex2;

float prevTempC;
float prevTempF;
float tempC;
float tempF;

float getTempC()
{
    return ((tempSensor*3.3)-0.600)*100.0;
}

float getTempF()
{
    return (9.0*getTempC()/5.0) + 32.0;
}

string getTime()
{
    char buffer[80];
    ctTime = time(NULL);
    struct tm * timeinfo;
    timeinfo = localtime(&ctTime);
    timeinfo->tm_hour = (timeinfo->tm_hour - 4)%24;
    strftime(buffer,80,"%I:%M\n",timeinfo);
    return string(buffer);
}

string getDate()
{
    char buffer[80];
    ctTime = time(NULL);
    struct tm * timeinfo;
    timeinfo = localtime(&ctTime);
    strftime(buffer,80,"%A, %B %d\n",timeinfo);
    return string(buffer);
}

weatherInfo prevWeather;

void tempThread(void const *args)
{
    mutex1.lock();
    screen1.cls();
    screen1.color(GREEN);
    screen1.printf("The indoor\ntemperature is:\n");
    mutex1.unlock();
    while (1) {
        tempC = getTempC();
        tempF = getTempF();

        mutex1.lock();
        screen1.locate(0, 2);
        screen1.color(BLACK);
        screen1.printf("%.0fC/%.0fF", prevTempC, prevTempF);
        screen1.locate(0, 2);
        screen1.color(GREEN);
        screen1.printf("%.0fC/%.0fF", tempC, tempF);

        screen1.locate(0,6);
        screen1.color(BLACK);
        screen1.printf("Weather in %s\n", prevWeather.zipcode);
        screen1.printf("%.0fC/%.0fF\n", prevWeather.tempC, prevWeather.tempF);
        screen1.printf("%s\n", prevWeather.condition);
        screen1.printf("%.2fkmh/%.2fmih\n", prevWeather.windSpeedKm, prevWeather.windSpeedMi);
        prevWeather = getWeatherInfo();
        screen1.locate(0,6);
        screen1.color(GREEN);
        screen1.printf("Weather in %s\n", prevWeather.zipcode);
        screen1.printf("%.0fC/%.0fF\n", prevWeather.tempC, prevWeather.tempF);
        screen1.printf("%s\n", prevWeather.condition);
        screen1.printf("%.2fkph/%.2fmph\n", prevWeather.windSpeedKm, prevWeather.windSpeedMi);
        mutex1.unlock();
        prevTempC = tempC;
        prevTempF = tempF;
        Thread::wait(6*1000);
    }
}

string prevTime;

void displayTime(void const* args)
{
    mutex1.lock();
    screen2.cls();
    screen2.locate(0,3);
    screen2.color(WHITE);
    screen2.printf("%s", getDate());
    prevTime = getTime();
    mutex1.unlock();
    while (1) {
        mutex1.lock();
        screen2.locate(0,0);
        screen2.color(BLACK);
        screen2.text_width(3);
        screen2.text_height(3);
        screen2.printf("%s", prevTime);
        screen2.locate(0,0);
        screen2.color(WHITE);
        screen2.printf("%s", getTime());
        prevTime = getTime();
        mutex1.unlock();
        Thread::wait(5000);
    }
}

void displayRedditFeed(void const* args)
{
    while (1) {
        TCPSocketConnection sock;
        sock.connect("ece4180.cloudapp.net", 80);
        //sock.connect("google.com", 80);

        char http_cmd[] = "GET /reddit/index.php HTTP/1.0\n\n";
        sock.send_all(http_cmd, sizeof(http_cmd)-1);

        char buffer[1000];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
        }
        sock.close();
        
        string all(buffer);
        all = all.substr(all.find("\r\n\r\n")+4);
        
        mutex1.lock();
        screen2.cls();
        screen2.printf("%s\n", all);
        mutex1.unlock();
        Thread::wait(5*1000);
    }
}


void setupScreens()
{
    screen1.baudrate(3000000);
    screen1.cls();
    screen2.baudrate(3000000);
    screen2.cls();
}

void setupEthernet()
{
    eth.init(); //Use DHCP
    eth.connect();
    //printf("Mac Address: %s\n", eth.getMACAddress());
    //printf("IP Address is %s\n", eth.getIPAddress());
}

void setupTime()
{
    if (ntp.setTime("nist1-macon.macon.ga.us") == 0) {
        printf("Set time successfully\r\n");
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    } else {
        printf("Error in getting time\r\n");
    }
}

void setupWeather()
{
    prevWeather = getWeatherInfo();
}

int main()
{
    mutex1.lock();
    setupScreens();
    screen1.color(RED);
    screen1.printf("Setting Up LCDs\nPlease wait...");
    screen2.color(RED);
    screen2.printf("Setting Up LAN\nPlease wait...");
    mutex1.unlock();
    setupEthernet();
    setupTime();
    setupWeather();

    mutex1.lock();
    screen1.cls();
    screen2.cls();
    mutex1.unlock();

    //Thread threadTime(displayTime);
    Thread threadTemp(tempThread);
    //Thread threadSerial(sendSerial);
    Thread redditThread(displayRedditFeed);

    while(1) {
        mutex1.lock();
        if(device.readable()) {
            char buffer[80];
            device.scanf("%s", buffer);
            if (buffer[0] == 'd') {
                device.printf("%s", getDate());
            }
            if (buffer[0] == 't') {
                device.printf("%s", getTime());
            }
            if (buffer[0] == 'a') {
                mutex1.lock();
                device.printf("%s\n", isItAlarmTime(&ctTime));
                mutex1.unlock();
            }
        }
        mutex1.unlock();
        wait_ms(1000);
    }
}