
#include "mbed.h"
#include <iostream>
#include <vector>
#include "sigfox.h"
#include "SoftSerial.h"
#include "message_1.h"
#include "message_2.h"
#include "DHT22.h"
#include "HX711.h"
#include "DS1820.h"
#include "temps.h"
#include "gps.h"

using namespace std;




void mesureTempExtHumidite(int &humidite, float &temperature);
void mesureTempInt(float &temperatureInt);
void mesureMasse(float &masse, long valeurTare);
void mesureGps(float &longit, float &lati);


//Serial sc(SERIAL_TX, SERIAL_RX, 9600);
//Serial device(PA_9, PA_10);
Serial pc (USBTX , USBRX);
DHT22 dht22(D3);
HX711 Balance(D12,D11);
DS1820 probe = A6;

//SoftSerial device(D3, D4);
//Serial sc2(D5, D4);


int main() {
   // device.baud(9600);
    //sc.printf("---New start ---\n");
   // while (!device.writeable()) { }
    //sc.printf("coucou 1 \n");
    
   /* device.printf("AT\r");;
    char a = device.getc();
    char b = device.getc();
    sc.printf("%c%c \n", a, b);
    sc.printf("%c", device.getc());
    */
    
    tempVeille.attach(activeVeille, 50.0f);
    
    float lat,lon;
    float longit = 12.3, lati = 18.6;
    int humidite= 18;  
    float temperatureExt = 12;
    float temperatureInt = 15;
    
    long valeur;
    long valeurTare ;
    float masse;
    
    valeurTare = Balance.getValue();  
    probe.search_ROM();
    char temp;

    
   
    // pc.printf("\n\n\rstart\n\r");
    while(1) {
      
        pc.printf("mesureTempExtHumidte ...\n\r");
        mesureTempExtHumidite(humidite, temperatureExt);
        pc.printf("mesureTempExtHumidte OK\n\r");
        mesureMasse(masse, valeurTare);
        
        pc.printf("mesureTempInt ...\n\r");
        mesureTempInt(temperatureInt);
        pc.printf("mesureTempInt OK\n\r");
        pc.printf("te:%.2f hu:%d ti:%.2f m:%f\n\r",temperatureExt, humidite, temperatureInt, masse);
        
        
        //getLatLong(lat , lon);
        pc.printf("lat: %f , long: %f\n\r" , lat , lon);
        //Message_1 msg1(1, temperatureExt, temperatureInt, humidite, masse);
        
        
        //msg1.send();
        //wait(600);
        wait(1);
    }
}

void mesureTempExtHumidite(int &humidite, float &temperatureExt){
    dht22.sample() ;
    humidite=dht22.getHumidity()/10.0;
    temperatureExt=dht22.getTemperature()/10.0;
   // humidite = 57;
   // temperatureExt = 17;
};

void mesureMasse(float &masse, long valeurTare){
    wait_ms(200);                                                       // Attente de 200 millisecondes
   float valeur = Balance.getValue();                                        // On récupère la valeur du module
    masse = ((double)valeur-(double)valeurTare)/11900 ;
};

void mesureTempInt(float &temperatureInt){
    probe.convert_temperature(DS1820::all_devices);
    temperatureInt = probe.temperature('c');
};


/*bool sendMessageToSigfox(Vector<Message*> msg){
    for(int i =0; i<msg.size(); i++){
        msg[i].send();
        wait_ms(100);
    };
};*/
