#include "mbed.h"
#include "HX711.h"
 
Serial pc(USBTX,USBRX);         // Déclaration du port série USB
 
HX711 Balance(D5,D6);       // Déclaration de l'objet HX711
 
int main() 
{
    pc.printf("\nDebut Enregistrement\n");
    
    long valeur;
    long valeurTare ;
    double poids;
    
    valeurTare = Balance.getValue();                                           // On récupère la valeur de la Tare
    while (true) 
    {
        wait_ms(200);                                                       // Attente de 200 millisecondes
        valeur = Balance.getValue();                                        // On récupère la valeur du module
        poids = ((double)valeur-(double)valeurTare)/11500;         // Convertionde la valeur de l'ADC en grammes
        pc.printf("Valeur : %ld          Poids : %.3lf\n\r",valeur,poids);    // Affichage du poids
    }
    
    pc.printf("\nFin Enregistrement\n");
}
 