 
#include "gps.h"

int dateRef = 90318;
 

Serial gps(D1, D0);
//TextLCD lcd(p11, p12, p15, p16, p29, p30); // rs, e, d4, d5, d6, d7

void Init()
{
    gps.baud(9600);
}

int getGPS(char* cDataBuffer,float *lat,float *lon,float *tmf,float *spd, int  *dat, char *ns, char *ew, char *stat)
{
    char nortSouth, eastWest, status;
    int  date,fq, nst;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed,altitude;
      
    if(strncmp(cDataBuffer,"$GPRMC", 6) == 0) 
    {
        sscanf(cDataBuffer, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &nortSouth, &longitude, &eastWest, &speed, &date);     
        
        if (latitude !=0)
            *lat = latitude*0.01;
        if (longitude != 0)
            *lon = longitude*0.01;
        
        *tmf = timefix;
        
        *spd = speed;
        if (date >= dateRef)
            *dat = date;

        if (nortSouth == 'N' | nortSouth == 'S')
            *ns = nortSouth;
        if (eastWest == 'W' | eastWest == 'E')
            *ew = eastWest;
        *stat = status;
        // pc.printf("GPRMC Fix: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", timefix, status, latitude, nortSouth, longitude, eastWest, speed, date);
        // pc.printf("GPRMC Fix: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", *tmf, *stat, *lat, *ns, *lon, *ew, *spd, *dat);
        return 0;
    }
    if(strncmp(cDataBuffer,"$GPGLL", 6) == 0) 
    {
        sscanf(cDataBuffer, "$GPGLL,%f,%c,%f,%c,%f", &latitude, &nortSouth, &longitude, &eastWest, &timefix);
        //pc.printf("%s",cDataBuffer); 
        if (latitude !=0)
            *lat = latitude * 0.01;
            
        if (longitude != 0)
            *lon = longitude * 0.01;
            
        *tmf = timefix;
        *spd = speed;
        
        if (nortSouth == 'N' | nortSouth == 'S')
            *ns = nortSouth;
            
        if (eastWest == 'W' | eastWest == 'E')
            *ew = eastWest;
        return 0;
    }
   
    if(strncmp(cDataBuffer,"$GPGGA", 6) == 0) 
    {
        sscanf(cDataBuffer, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &nortSouth, &longitude, &eastWest, &fq, &nst, &altitude);
        if (latitude !=0)
            *lat = latitude * 0.01;
            
        if (longitude != 0)
            *lon = longitude * 0.01;
            
        //*alt = altitude; 
        *tmf = timefix;
        
        if (nortSouth == 'N' | nortSouth == 'S')
            *ns = nortSouth;
            
        if (eastWest == 'W' | eastWest == 'E')
            *ew = eastWest;
        return 0;
                
    }
    return -1;


}


 
int getLatLong(float &lat , float &lon) 
{   
    Init();
    char Buffer[128],str[7];
    char ns, ew, status;
    int  date,gpsACK;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed;
    memset(Buffer,0,sizeof(Buffer));
    date = 0;
    latitude = longitude = timefix = speed = 0;
    ns = ew = status =0;

    if(gps.readable())
    {
        gps.gets(Buffer,90);
        if(Buffer[0] == '$'){
            memcpy(str,Buffer, 6);
            //printf("\nrecv: %s\n",str);
            gpsACK = getGPS(Buffer, &latitude, &longitude, &timefix, &speed, &date, &ns, &ew, &status);
            
            }
    }    
  
    if (gpsACK == 0)
    {
        lat = latitude;
        lon = longitude;
    }
        
       
     
}
 
 
