#include "mbed.h"

// Declare output LEDs
DigitalOut ledgreen(PTD5);
DigitalOut ledred(PTE29);

// Serial for debuggin purposes

void initialize_ticker();

int main() {
    ledred = 1;
    ledgreen = 0;
    initialize_ticker();
    while(1){
        
    }
}

void flip() {
    //clear interrupt
    PIT->CHANNEL[1].TFLG |= PIT_TFLG_TIF_MASK;
    ledgreen = !ledgreen;
    ledred = !ledred;
}

void initialize_ticker(){ 
    //enable clock 
    SIM->SCGC6 |= SIM_SCGC6_PIT_MASK;
    //set to zero to enable PIT 
    PIT->MCR = 0x00; 
    //clear interrup before enabling it
    PIT->CHANNEL[1].TFLG |= PIT_TFLG_TIF_MASK;
    PIT->CHANNEL[1].LDVAL = 0x00; //.04us 
    //enable interrup
    PIT->CHANNEL[1].TCTRL |= PIT_TCTRL_TIE_MASK;
    //enable interrtup
    __enable_irq();
    NVIC_SetVector(PIT_IRQn, (uint32_t)flip);
    NVIC_EnableIRQ(PIT_IRQn); 
    //start timer 
    PIT->CHANNEL[1].TCTRL |= PIT_TCTRL_TEN_MASK;
}
