//            Table des variables, des bits et des Registres d’E/S
//_______________________________________________________________________________
// Ports et variables d’E/S	   | Bits et Reg. d’E/S  |	Ecriture Modbus | Adresse
// ------------------------------------------------------------------------------
// Led2 : PB_8				   | bit 0 de BitsOut[0] | oui (fonction 5) | 0x1000
// BP1 : PA_8				   | bit 0 de BitsIn[0]	 | non	            | 0x2000
// BP2 : PB_12				   | bit 1 de BitsIn[0]	 | non	            | 0x2001
// Rap_Cyc * 100 (pour Moteur) | RegOut[0]	         | oui (fonction 6) | 0x3000
// Pot.read() * 100 (pour Led1)| RegOut[1]	         | non	            | 0x3001
// Pot.read_u16 ()  (pour Pot) | RegIn[0]	         | non	            | 0x4000 
//-------------------------------------------------------------------------------

//       Exemple de trames de requete
// allumer Led2 : 07 05 1000 FF00
// Lecture Etat des 2 boutons poussoir : 07 02 2000 0002
// Rapport Cyclique =50% pour moteur (50=0x32): 07 06 3000 0032
// Rapport Cyclique =100% pour moteur (100=0x64): 07 06 3000 0064
// Lecture de la valeur numerique de l'entree analogique PA_0 (Pot) : 07 04 4000 0001

#include "mbed.h"
#include "mb.h"

#define BITS_OUT_START  0x1001  //Bits de sorties         (fonctions 1 et 5)
#define BITS_OUT_NBITS  16
#define BITS_OUT_BYTES  BITS_OUT_NBITS/8  //16/8 = 2 octets

#define BITS_IN_START   0x2001  //Bits d'entées           (fonction 2)
#define BITS_IN_NBITS   16
#define BITS_IN_BYTES   BITS_IN_NBITS/8  //16/8 = 2 octets

#define REG_OUT_START  0x3001  //Registres de sorties     (fonctions 3 et 6)
#define REG_OUT_NREGS  4

#define REG_IN_START   0x4001  //Registres d'entées       (fonction 4)
#define REG_IN_NREGS   4

#define SLAVE_ID       0x07

static USHORT   BitsOutStart = BITS_OUT_START;          // (fonctions 1 et 5)
static UCHAR    BitsOut[BITS_OUT_BYTES] = {0xA5,0x5A};
static USHORT   BitsInStart = BITS_IN_START;            // (fonction 2)
static UCHAR    BitsIn[BITS_IN_BYTES] = {0x3C,0xC3};
static USHORT   RegOutStart = REG_OUT_START;            // (fonctions 3 et 6)
static USHORT   RegOut[REG_OUT_NREGS] = {0x0123,0x4567,0x89AB,0xCDEF};
static USHORT   RegInStart = REG_IN_START;              // (fonction 4)
static USHORT   RegIn[REG_IN_NREGS] = {0x1122,0x3344,0x5566,0x7788};

int main() {
   eMBInit( MB_RTU, SLAVE_ID, 0, 9600, MB_PAR_NONE );
   eMBEnable();

   PwmOut moteur(PB_11);
   PwmOut Led1(..........);
   AnalogIn Pot(PA_0);
   DigitalIn BP1(PA_8,PullUp);
   DigitalIn BP2(..................);
   DigitalOut Led2(PB_8);
   moteur.period_ms(.......);
   RegOut[0]=20;  //RegOut[0] = rapport cyclique du moteur * 100 = 20% 
   while(1)  { 
      //**** 1 ****//
      eMBPoll();
      //**** 2 ****//
      if(BitsOut[0] & 0x01) Led2=1;  else  Led2=0;
      moteur = RegOut[0]/100.0;
      //**** 3 ****//
      if(!BP1 && RegOut[0] <100) {
         RegOut[0] = RegOut[0] + 10;
         moteur = RegOut[0]/.........; 
         wait(0.5);
      }
      if(!BP2 && RegOut[0] > ....){
         RegOut[0] = RegOut[0] - ....;
         moteur = RegOut[0]/.........; 
         wait(......);
      }
      Led1 = Pot.read(); 
      //**** 4 ****//
      RegOut[1] = Pot.read() * .......;
      //**** 5 ****//
      if(Led2) BitsOut[0] |=.....;
      else     BitsOut[0] &=.....;
      if(BP1)  BitsIn[0]  |=.....;
      else     BitsIn[0]  &=.....;
      if(BP2)  BitsIn[0]  |=.....;
      else     BitsIn[0]  &=.....;
      RegIn[0] = Pot.read_u16();
   }
}


































// Procedure résevée pour les bits de sorties (Foction 1 et 5)
// pucRegBuffer => coils buffer			usAddress => coils address
// usNCoils => coils number 			eMode => read or write 
eMBErrorCode
eMBRegCoilsCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNCoils, eMBRegisterMode eMode )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iIntRegIndex;
    int                iIntBufNum;
    int                iIntBitNum;
    int                iExtRegIndex=0;
    int                iExtBufNum;
    int                iExtBitNum;
    UCHAR            ucTemp;
    if( ( usAddress >= BITS_OUT_START )
        && ( usAddress + usNCoils <= BITS_OUT_START + BITS_OUT_NBITS ) )
    {
        iIntRegIndex = ( int )( usAddress - BitsOutStart );

        while( usNCoils > 0 )
        {
            iIntBufNum=iIntRegIndex/8;
            iIntBitNum=iIntRegIndex%8;
            iExtBufNum=iExtRegIndex/8;
            iExtBitNum=iExtRegIndex%8;

            switch ( eMode )
            {
            case MB_REG_READ:
                // Read coils
                if(iExtBitNum==0){
                    pucRegBuffer[iExtBufNum]=0;
                }
                ucTemp=(BitsOut[iIntBufNum]>>iIntBitNum) & 1;
                pucRegBuffer[iExtBufNum]|=ucTemp<<iExtBitNum;
                break;

            case MB_REG_WRITE:
                // Write coils
				ucTemp=BitsOut[iIntBufNum]&(~(1<<iIntBitNum));
				ucTemp|=((pucRegBuffer[iExtBufNum]>>iExtBitNum) & 1)<<iIntBitNum;
				BitsOut[iIntBufNum]=ucTemp;
                break;
            }
            iIntRegIndex++;
            iExtRegIndex++;
            usNCoils--;

        }
    }
    else
    {
        eStatus = MB_ENOREG;
    }
    return eStatus;
}

// Procedure résevée pour les bits d'entrées (Foction 2)
// pucRegBuffer => discrete buffer		usAddress => discrete address
// usNDiscrete => discrete number  
eMBErrorCode
eMBRegDiscreteCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNDiscrete )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iIntRegIndex;
    int                iIntBufNum;
    int                iIntBitNum;
    int                iExtRegIndex=0;
    int                iExtBufNum;
    int                iExtBitNum;
    UCHAR            ucTemp;
    if( ( usAddress >= BITS_IN_START )
        && ( usAddress + usNDiscrete <= BITS_IN_START + BITS_IN_NBITS ) )
    {
        iIntRegIndex = ( int )( usAddress - BitsInStart );

        while( usNDiscrete > 0 )
        {
            iIntBufNum=iIntRegIndex/8;
            iIntBitNum=iIntRegIndex%8;
            iExtBufNum=iExtRegIndex/8;
            iExtBitNum=iExtRegIndex%8;

            // Read discrete inputs
            if(iExtBitNum==0){
                pucRegBuffer[iExtBufNum]=0;
            }
            ucTemp=(BitsIn[iIntBufNum]>>iIntBitNum) & 1;
            pucRegBuffer[iExtBufNum]|=ucTemp<<iExtBitNum;

            iIntRegIndex++;
            iExtRegIndex++;
            usNDiscrete--;
        }
    }
    else
    {
        eStatus = MB_ENOREG;
    }
    return eStatus;
}

// Procedure résevée pour les registres de sorties (Foction 3 et 6)
// pucRegBuffer => holding register buffer	 usAddress holding => register address
// usNRegs holding register number           eMode => read or write 
eMBErrorCode
eMBRegHoldingCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNRegs, eMBRegisterMode eMode )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iRegIndex;

    if( ( usAddress >= REG_OUT_START ) &&
        ( usAddress + usNRegs <= REG_OUT_START + REG_OUT_NREGS ) )
    {
        iRegIndex = ( int )( usAddress - RegOutStart );
        switch ( eMode )
        {
        //*** Pass current register values to the protocol stack. ***
        case MB_REG_READ:
            while( usNRegs > 0 )
            {
                *pucRegBuffer++ = ( UCHAR ) ( RegOut[iRegIndex] >> 8 );
                *pucRegBuffer++ = ( UCHAR ) ( RegOut[iRegIndex] & 0xFF );
                iRegIndex++;
                usNRegs--;
            }
            break;

        //***Update current register values with new values from the protocol stack.***
        case MB_REG_WRITE:
            while( usNRegs > 0 )
            {
                RegOut[iRegIndex] = *pucRegBuffer++ << 8;
                RegOut[iRegIndex] |= *pucRegBuffer++;
                iRegIndex++;
                usNRegs--;
            }
        }
    }
    else
    {
        eStatus = MB_ENOREG;
    }
    return eStatus;
}
// Procedure résevée pour les registres de sorties (Foction 4)
// pucRegBuffer => input register buffer		usAddress => input register address
// usNRegs input register number  
eMBErrorCode
eMBRegInputCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNRegs )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iRegIndex;

    if( ( usAddress >= REG_IN_START )
        && ( usAddress + usNRegs <= REG_IN_START + REG_IN_NREGS ) )
    {
        iRegIndex = ( int )( usAddress - RegInStart );
        while( usNRegs > 0 )
        {
            *pucRegBuffer++ = ( unsigned char )( RegIn[iRegIndex] >> 8 );
            *pucRegBuffer++ = ( unsigned char )( RegIn[iRegIndex] & 0xFF );
            iRegIndex++;
            usNRegs--;
        }
    }
    else
    {
        eStatus = MB_ENOREG;
    }
    return eStatus;
}
