#include "mbed.h"
#include "LSM9DS0.h"
//#include <math.h>

// timer 1
#define LOOPTIME  1000                         // 1 ms
unsigned long lastMilli = 0;
// sampling time
float T = 0.001;

// Serial
Serial pc(USBTX, USBRX);

Timer t;

void read_sensor(void);

LSM9DS0 sensor(I2C_MODE, 0x1D, 0x6B);

int sensor_flag = 0;                 // sensor initial flag
int sensor_count = 0;

// sensor data
int16_t Gyro_axis_data[3] = {0};     // X, Y, Z axis
int16_t Acce_axis_data[3] = {0};     // X, Y, Z axis
int16_t Magn_axis_data[3] = {0};     // X, Y, Z axis

// sensor gain
#define Gyro_gain_x   0        
#define Gyro_gain_y   0           
#define Gyro_gain_z   0.00122173            // datasheet : 70 mdeg/digit
#define Acce_gain_x   0                
#define Acce_gain_y   0                  
#define Acce_gain_z   0     
#define Magn_gain     0

// sensor filter correction data
float Gyro_axis_data_f[3];
float Gyro_axis_data_f_old[3];
float Gyro_scale[3];                          // scale = (data - zero) * gain
float Gyro_axis_zero[3] = {0,0,0};            

float Acce_axis_data_f[3];
float Acce_axis_data_f_old[3];
float Acce_scale[3];                          // scale = (data - zero) * gain
float Acce_axis_zero[3] = {0,0,0};         

float Magn_axis_data_f[3];
float Magn_axis_data_f_old[3];
float Magn_scale[3];                          // scale = (data - zero) * gain
float Magn_axis_zero[3] = {0,0,0};      

int main()
{
    pc.baud(9600);
    pc.printf("Test LSM9DS0 \r\n");
    t.start();
    sensor.begin();
    while(1) 
    {
        // timer 1
        if((t.read_us() - lastMilli) >= LOOPTIME)          // 2000 us = 2 ms
        {    
            lastMilli = t.read_us();

            // sensor initial start
            if(sensor_flag == 0) 
            {
                sensor_count++;
                if(sensor_count >= 50) 
                {
                    sensor_flag  = 1;
                    sensor_count = 0;
                }
            } 
            else 
            {
                read_sensor();
                pc.printf("Ax : %3d , Ay : %3d , Az : %3d \r\n", Acce_axis_data[0],Acce_axis_data[1],Acce_axis_data[2]);
                pc.printf("Gx : %3d , Gy : %3d , Gz : %3d \r\n", Gyro_axis_data[0],Gyro_axis_data[1],Gyro_axis_data[2]);
                pc.printf("Mx : %3d , My : %3d , Mz : %3d \r\n\n", Magn_axis_data[0],Magn_axis_data[1],Magn_axis_data[2]);
            }
        }
    }   // while(1) end
}

void read_sensor(void)
{
    // sensor raw data
    Gyro_axis_data[0] = sensor.readRawGyroX();
    Gyro_axis_data[1] = sensor.readRawGyroY();
    Gyro_axis_data[2] = sensor.readRawGyroZ();

    Acce_axis_data[0] = sensor.readRawAccelX();
    Acce_axis_data[1] = sensor.readRawAccelY();
    Acce_axis_data[2] = sensor.readRawAccelZ();

    Magn_axis_data[0] = sensor.readRawMagX();
    Magn_axis_data[1] = sensor.readRawMagY();
    Magn_axis_data[2] = sensor.readRawMagZ();
}