/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

#include "N5110.h"
#include "Gamepad.h"
#include "SnakeEngine.h"


Gamepad gamePad;
N5110 lcd;
SnakeEngine snakeEngine(gamePad,lcd);

int gameSpeed;




int main(){
    int fps = 6;
    gamePad.init();
    gamePad.reset_buttons();

    lcd.init();
    snakeEngine.init();
    snakeEngine.welcome();
    gameSpeed = snakeEngine.getGameSpeed(); // initiallize the game speed to lowest 

    fps = gameSpeed*2;
    while(true){
        snakeEngine.runGameEngine();
        gameSpeed = snakeEngine.getGameSpeed();
        fps = gameSpeed*2;
        wait(1.0f/fps); // we wait accordingly to game speed
    }
    
}