#include "snake_defines.h"
#include "N5110.h"
#include "Gamepad.h"

class SnakeEngine
{

private:
    //Direction of out snake
    //0 - LEFT, 1 - RIGHT, 2 - DOWN, 3- UP
    int dirSnake;
    int gameScore;
    int gameLife;
    int gameObjectSize;        //width of the snake
    unsigned int snakeSize;    // initial length of the sanke
    int obstaclesNum ; /********************update*******************/
    unsigned int level;        /********************update*******************/

    gameObject snake[100]; // size of the snake. Lets hope no one can grow the snake more than 100 :D

    gameObject obstacles[12]
    ; /********************update*******************/

    gameObject food;

    stateGame state;

    Gamepad &gamePad;
    N5110 &lcd;

    bool bLeft;
    bool bRight;
    bool bDown;
    bool bUp;

    int AREA_X;
    int AREA_Y;
    int AREA_X_min;
    int AREA_Y_min;
    int gameSpeed;

    void drawSnake();
    void drawFood();
    void drawScore();
    void regenFood();
    void readUserInput();

public:
    SnakeEngine(Gamepad &, N5110 &);
    ~SnakeEngine();
    void drawGameFrame();
    void isColliding();
    void setupGame();
    void handleUserInput();
    void updateGame();
    void playGame();
    void gameIsPaused();
    void gameIsLost();
    void init();
    void runGameEngine();
    void welcome();
    int getGameSpeed();
    void drawObstacles();      /********************update*******************/
    void obstaclesPosition(); /********************update*******************/
};