/**
 * File:      im4oled_default_config.h
 *
 * Author:    Modtronix Engineering - www.modtronix.com
 *
 * Description:
 *
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header.
 *
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */
#ifndef _IM4OLED_DEFAULT_CONFIG_H_
#define _IM4OLED_DEFAULT_CONFIG_H_

//This file requires a file called "modtronix_config.h" to exist in the project!
//Use this file to override any of the default defines below. Do NOT edit this file!
#if !defined(NO_MODTRONIX_CONFIG)
    #include "modtronix_config.h"
#endif

// Uncomment this to turn off the builtin splash
#if !defined(OLED_HAS_SPLASH)
#define OLED_HAS_SPLASH     0
#endif

//Don't use std::vector. This saves a lot of Flash space. Also, std::vector uses heap which is not always desirable.
//When NOT using std::vector, OLED_HEIGHT and OLED_WIDTH are required.
#if !defined(OLED_USE_VECTOR)
#define OLED_USE_VECTOR     0
#endif

// Used when std::vector not used. In this case, buffer has to be assigned statically.
#if !defined(OLED_HEIGHT)
#define OLED_HEIGHT     64
#endif

#if !defined(OLED_WIDTH)
#define OLED_WIDTH      128
#endif

// Uncomment this to enable all functionality
#if !defined(GFX_ENABLE_ABSTRACTS)
#define GFX_ENABLE_ABSTRACTS    0
#endif

// Uncomment this to enable only runtime font scaling, without all the rest of the Abstracts
#if !defined(GFX_SIZEABLE_TEXT)
#define GFX_SIZEABLE_TEXT       1
#endif

#endif
